% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_checks.R
\name{.validateMSstatsConverterParameters}
\alias{.validateMSstatsConverterParameters}
\title{Generic parameter validation for all MSstats converters using configuration object}
\usage{
.validateMSstatsConverterParameters(config)
}
\arguments{
\item{config}{A list containing all converter parameters. See details for required structure.}
}
\value{
NULL (throws error if validation fails)
}
\description{
Generic parameter validation for all MSstats converters using configuration object
}
\details{
The config list should contain the input and optionally other parameters:
\itemize{
\item input: input data (required)
\item annotation: annotation data (optional)
\item intensity: intensity type (optional)
\item filter_with_Qvalue: Q-value filter setting (default: FALSE)
\item qvalue_cutoff: Q-value cutoff (default: 0.01)
\item useUniquePeptide: unique peptide setting (default: TRUE)
\item removeFewMeasurements: remove few measurements setting (default: TRUE)
\item removeProtein_with1Feature: remove single feature proteins setting (default: FALSE)
\item summaryforMultipleRows: aggregation function (default: max)
\item calculateAnomalyScores: anomaly detection setting (default: FALSE)
\item anomalyModelFeatures: anomaly model features (default: c())
\item anomalyModelFeatureTemporal: temporal features (default: c())
\item removeMissingFeatures: missing feature threshold (default: 0.5)
\item anomalyModelFeatureCount: feature count for anomaly model (default: 100)
\item runOrder: run order data (default: NULL)
\item n_trees: number of trees (default: 100)
\item max_depth: max tree depth (default: "auto")
\item numberOfCores: number of cores (default: 1)
\item use_log_file: logging setting (default: TRUE)
\item append: append setting (default: FALSE)
\item verbose: verbose setting (default: TRUE)
\item log_file_path: log file path (default: NULL)
\item excludedFromQuantificationFilter: filter setting (default: NULL)
}
}
\keyword{internal}
