% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters_OpenSWATHtoMSstatsFormat.R
\name{OpenSWATHtoMSstatsFormat}
\alias{OpenSWATHtoMSstatsFormat}
\title{Import OpenSWATH files}
\usage{
OpenSWATHtoMSstatsFormat(
  input,
  annotation,
  filter_with_mscore = TRUE,
  mscore_cutoff = 0.01,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeProtein_with1Feature = FALSE,
  summaryforMultipleRows = max,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{input}{name of MSstats input report from OpenSWATH, which includes feature-level data.}

\item{annotation}{name of 'annotation.txt' data which includes Condition, BioReplicate, Run.
Run should be the same as filename.}

\item{filter_with_mscore}{TRUE(default) will filter out the features that have greater than mscore_cutoff in m_score column. Those features will be removed.}

\item{mscore_cutoff}{Cutoff for m_score. Default is 0.01.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for more than one proteins.
We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that have 1 or 2 measurements across runs.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have only 1 feature, which is the combination of peptide, precursor charge, fragment and charge. FALSE is default.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple measurements for certain feature and certain run, use highest or sum of multiple intensities.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{...}{additional parameters to \code{data.table::fread}.}
}
\value{
data.frame in the MSstats required format.
}
\description{
Import OpenSWATH files
}
\examples{
os_raw = system.file("tinytest/raw_data/OpenSWATH/openswath_input.csv", 
                             package = "MSstatsConvert")
annot = system.file("tinytest/raw_data/OpenSWATH/annot_os.csv", 
                    package = "MSstatsConvert")
os_raw = data.table::fread(os_raw) 
annot = data.table::fread(annot)

os_imported = OpenSWATHtoMSstatsFormat(os_raw, annot, use_log_file = FALSE)
head(os_imported)

}
\author{
Meena Choi, Olga Vitek.
}
