% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstatsConvert_core_functions.R
\docType{class}
\name{MSstatsInputFiles-class}
\alias{MSstatsInputFiles-class}
\alias{MSstatsDIAUmpireFiles-class}
\alias{MSstatsMaxQuantFiles-class}
\alias{MSstatsOpenMSFiles-class}
\alias{MSstatsOpenSWATHFiles-class}
\alias{MSstatsProgenesisFiles-class}
\alias{MSstatsProteomeDiscovererFiles-class}
\alias{MSstatsSkylineFiles-class}
\alias{MSstatsSpectroMineFiles-class}
\alias{MSstatsSpectronautFiles-class}
\alias{MSstatsPhilosopherFiles-class}
\alias{MSstatsDIANNFiles-class}
\alias{MSstatsFragPipeFiles-class}
\alias{MSstatsMetamorpheusFiles-class}
\alias{MSstatsProteinProspectorFiles-class}
\title{Class to model files that describe a single MS dataset.}
\description{
Class to model files that describe a single MS dataset.

MSstatsDIAUmpireFiles: class for DIAUmpire files.

MSstatsMaxQuantFiles: class for MaxQuant files.

MSstatsOpenMSFiles: class for OpenMS files.

MSstatsOpenSWATHFiles: class for OpenSWATH files.

MSstatsProgenesisFiles: class for Progenesis files.

MSstatsProteomeDiscovererFiles: class for ProteomeDiscoverer files.

MSstatsSkylineFiles: class for Skyline files.

MSstatsSkylineFiles: class for SpectroMine files.

MSstatsSpectronautFiles: class for Spectronaut files.

MSstatsPhilosopherFiles: class for Philosopher files.

MSstatsDIANNFiles: class for DIA-NN files.

MSstatsFragPipeFiles: class for FragPipe files.

MSstatsMetamorpheusFiles: class for Metamorpheus files.

MSstatsProteinProspectorFiles: class for ProteinProspector files.
}
\section{Slots}{

\describe{
\item{\code{files}}{named list of files generated by a signal processing tools.
In most cases, this will be a single file named \code{input}.
In some cases, multiple files are used, for example \code{MaxQuant} outputs
\code{evidence} and \code{proteinGroups} files.}

\item{\code{type}}{character: "MSstats" or "MSstatsTMT".}

\item{\code{tool}}{character: name of a signal processing tools that generated the
output. Possible values are: DIAUmpire, MaxQuant, OpenMS, OpenSWATH,
Progenesis, ProteomeDiscoverer, Skyline, SpectroMine, Spectronaut.}

\item{\code{version}}{description of a software version of the signal processing tool.
Not implemented yet.}
}}

\keyword{internal}
