% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstatsConvert_core_functions.R
\name{MSstatsClean}
\alias{MSstatsClean}
\alias{MSstatsClean,MSstatsDIAUmpireFiles-method}
\alias{MSstatsClean,MSstatsMaxQuantFiles-method}
\alias{MSstatsClean,MSstatsOpenMSFiles-method}
\alias{MSstatsClean,MSstatsOpenSWATHFiles-method}
\alias{MSstatsClean,MSstatsProgenesisFiles-method}
\alias{MSstatsClean,MSstatsProteomeDiscovererFiles-method}
\alias{MSstatsClean,MSstatsSkylineFiles-method}
\alias{MSstatsClean,MSstatsSpectroMineFiles-method}
\alias{MSstatsClean,MSstatsSpectronautFiles-method}
\alias{MSstatsClean,MSstatsPhilosopherFiles-method}
\alias{MSstatsClean,MSstatsDIANNFiles-method}
\alias{MSstatsClean,MSstatsMetamorpheusFiles-method}
\alias{MSstatsClean,MSstatsProteinProspectorFiles-method}
\title{Clean files generated by a signal processing tools.}
\usage{
MSstatsClean(msstats_object, ...)

\S4method{MSstatsClean}{MSstatsDIAUmpireFiles}(msstats_object, use_frag, use_pept)

\S4method{MSstatsClean}{MSstatsMaxQuantFiles}(
  msstats_object,
  protein_id_col,
  remove_by_site = FALSE,
  channel_columns = "Reporterintensitycorrected"
)

\S4method{MSstatsClean}{MSstatsOpenMSFiles}(msstats_object)

\S4method{MSstatsClean}{MSstatsOpenSWATHFiles}(msstats_object)

\S4method{MSstatsClean}{MSstatsProgenesisFiles}(msstats_object, runs, fix_colnames = TRUE)

\S4method{MSstatsClean}{MSstatsProteomeDiscovererFiles}(
  msstats_object,
  quantification_column,
  protein_id_column,
  sequence_column,
  remove_shared,
  remove_protein_groups = TRUE,
  intensity_columns_regexp = "Abundance"
)

\S4method{MSstatsClean}{MSstatsSkylineFiles}(msstats_object)

\S4method{MSstatsClean}{MSstatsSpectroMineFiles}(msstats_object)

\S4method{MSstatsClean}{MSstatsSpectronautFiles}(
  msstats_object,
  intensity,
  calculateAnomalyScores,
  anomalyModelFeatures
)

\S4method{MSstatsClean}{MSstatsPhilosopherFiles}(
  msstats_object,
  protein_id_col,
  peptide_id_col,
  channels,
  remove_shared_peptides
)

\S4method{MSstatsClean}{MSstatsDIANNFiles}(
  msstats_object,
  MBR = TRUE,
  quantificationColumn = "FragmentQuantCorrected"
)

\S4method{MSstatsClean}{MSstatsMetamorpheusFiles}(msstats_object, MBR = TRUE, qvalue_cutoff = 0.05)

\S4method{MSstatsClean}{MSstatsProteinProspectorFiles}(msstats_object)
}
\arguments{
\item{msstats_object}{object that inherits from \code{MSstatsInputFiles} class.}

\item{...}{additional parameter to specific cleaning functions.}

\item{use_frag}{TRUE will use the selected fragment for each peptide.
'Selected_fragments' column is required.}

\item{use_pept}{TRUE will use the selected fragment for each protein
'Selected_peptides' column is required.}

\item{protein_id_col}{character, name of a column with names of proteins.}

\item{remove_by_site}{logical, if TRUE, proteins only identified by site will
be removed.}

\item{channel_columns}{character, regular expression that identifies channel columns
in TMT data.}

\item{runs}{chr, vector of Run labels.}

\item{fix_colnames}{lgl, if TRUE, one of the rows will be used as colnames.}

\item{quantification_column}{chr, name of a column used for quantification.}

\item{protein_id_column}{chr, name of a column with protein IDs.}

\item{sequence_column}{chr, name of a column with peptide sequences.}

\item{remove_shared}{lgl, if TRUE, shared peptides will be removed.}

\item{remove_protein_groups}{if TRUE, proteins with numProteins > 1 will be removed.}

\item{intensity_columns_regexp}{regular expressions that defines intensity columns.
Defaults to "Abundance", which means that columns that contain the word "Abundance"
will be treated as corresponding to intensities for different channels.}

\item{intensity}{chr, specifies which column will be used for Intensity.}

\item{calculateAnomalyScores}{logical, whether to calculate anomaly scores}

\item{anomalyModelFeatures}{character vector, specifies which columns will be used for anomaly detection model. Can be NULL if calculateAnomalyScores=FALSE.}

\item{peptide_id_col}{character name of a column that identifies peptides}

\item{channels}{character vector of channel labels}

\item{remove_shared_peptides}{logical, if TRUE, shared peptides will be
removed based on the IsUnique column from Philosopher output}

\item{MBR}{True if analysis was done with match between runs}

\item{quantificationColumn}{Use 'FragmentQuantCorrected'(default) column for quantified intensities for DIANN 1.8.x.
Use 'FragmentQuantRaw' for quantified intensities for DIANN 1.9.x.
Use 'auto' for quantified intensities for DIANN 2.x where each fragment intensity is a separate column, e.g. Fr0Quantity.}

\item{qvalue_cutoff}{The q-value cutoff for filtering peaks detected by MBR}
}
\value{
data.table

data.table

data.table

data.table

data.table

data.table

data.table

data.table

data.table

data.table

data.table

data.table

data.table
}
\description{
Clean files generated by a signal processing tools.

Clean DIAUmpire files

Clean MaxQuant files

Clean OpenMS files

Clean OpenSWATH files

Clean Progenesis files

Clean ProteomeDiscoverer files

Clean Skyline files

Clean SpectroMine files

Clean Spectronaut files

Clean Philosopher files

Clean DIA-NN files

Clean Metamorpheus files

Clean Protein Prospector files
}
\examples{
evidence_path = system.file("tinytest/raw_data/MaxQuant/mq_ev.csv", 
                            package = "MSstatsConvert")
pg_path = system.file("tinytest/raw_data/MaxQuant/mq_pg.csv", 
                      package = "MSstatsConvert")
evidence = read.csv(evidence_path)
pg = read.csv(pg_path)
imported = MSstatsImport(list(evidence = evidence, protein_groups = pg),
                         "MSstats", "MaxQuant")
cleaned_data = MSstatsClean(imported, protein_id_col = "Proteins")
head(cleaned_data)

}
