% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{supportedOrganisms}
\alias{supportedOrganisms}
\title{Get the list of supported organisms for a given database}
\usage{
supportedOrganisms(database)
}
\arguments{
\item{database}{The database name. It must be one of: \code{GO}, \code{KEGG}, \code{MsigDB},
\code{WikiPathways}, \code{Reactome}, \code{Enrichr}, \code{DO}, \code{NCG}, \code{DisGeNET}, \code{COVID19}}
}
\value{
A \code{character} vector listing all the supported organisms for the database
specified by the user.
}
\description{
This function provides the list of supported organisms for different
databases, namely Gene Ontology (GO), Kyoto Encyclopedia of Genes and
Genomes (KEGG), MsigDB, WikiPathways, Reactome, Enrichr, Disease Ontology
(DO), Network of Cancer Genes (NCG), DisGeNET, and COVID19.
}
\note{
To perform the functional enrichment of genes, MIRit uses the \code{geneset} R
package to download gene sets from the above mentioned databases.
}
\examples{
# get the supported organisms for GO database
supportedOrganisms("GO")

# get the supported organisms for Reactome
supportedOrganisms("Reactome")

}
\references{
Liu, Y., Li, G. Empowering biologists to decode omics data: the Genekitr R
package and web server. BMC Bioinformatics 24, 214 (2023).
\url{https://doi.org/10.1186/s12859-023-05342-9}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
