% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{enrichTargets}
\alias{enrichTargets}
\title{Perform an enrichment analysis of integrated microRNA targets}
\usage{
enrichTargets(
  mirnaObj,
  database = "GO",
  category = NULL,
  organism = "Homo sapiens",
  pCutoff = 0.05,
  pAdjustment = "fdr",
  minSize = 10L,
  maxSize = 500L
)
}
\arguments{
\item{mirnaObj}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object
containing miRNA and gene data}

\item{database}{The name of the database used for the enrichment analysis.
It must be one of: \code{GO}, \code{KEGG}, \code{MsigDB}, \code{WikiPathways}, \code{Reactome},
\code{Enrichr}, \code{DO}, \code{NCG}, \code{DisGeNET}, \code{COVID19}. Default is \code{GO}}

\item{category}{The desired subcategory of gene sets present in \code{database}.
Please, see the \emph{details} section to check the available categories for
each database. Default is NULL to use default categories}

\item{organism}{The name of the organism under consideration. The different
databases have different supported organisms. To see the list of supported
organisms for a given database, use the \code{\link[=supportedOrganisms]{supportedOrganisms()}} function.
Default is \verb{Homo sapiens}}

\item{pCutoff}{The adjusted p-value cutoff to use for statistical
significance. The default value is \code{0.05}}

\item{pAdjustment}{The p-value correction method for multiple testing. It
must be one of: \code{fdr} (default), \code{BH}, \code{none}, \code{holm}, \code{hochberg}, \code{hommel},
\code{bonferroni}, \code{BY}}

\item{minSize}{The minimum size for a gene set. All gene sets containing
less than this number of genes will not be considered. Default is 10}

\item{maxSize}{The maximum size for a gene set. All gene sets containing
more than this number of genes will not be considered. Default is 500}
}
\value{
This function produces a \code{list} object with two elements, namely
'upregulated' and 'downregulated', each containing a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}}
object storing enrichment results of upregulated and downregulated target
genes, respectively.

To access results of \code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}}
objects, the user can use the \code{\link[=enrichmentResults]{enrichmentResults()}} function. Additionally,
MIRit provides several functions to graphically represent enrichment
analyses, including \code{\link[=enrichmentBarplot]{enrichmentBarplot()}}, and \code{\link[=enrichmentDotplot]{enrichmentDotplot()}}.
}
\description{
This function allows to perform an over-representation analysis (ORA) of
integrated miRNA targets in order to explore the biological effects of
targets that are statistically associated/correlated with DE-miRNAs. The
enrichment analysis can be performed using different databases, namely
Gene Ontology (GO), Kyoto Encyclopedia of Genes and Genomes (KEGG), MsigDB,
WikiPathways, Reactome, Enrichr, Disease Ontology (DO), Network of Cancer
Genes (NCG), DisGeNET, and COVID19.
}
\details{
For each database, different organisms are supported. To check the supported
organisms for a given database, MIRit provides the \code{\link[=supportedOrganisms]{supportedOrganisms()}}
function.

Moreover, since different database support multiple subcategories, the
\code{category} parameter can be set to specify the desired resource. For
specific information regarding the available categories for the different
databases, check the \emph{details} section of the \code{\link[=enrichGenes]{enrichGenes()}} documentation.
}
\note{
To download gene sets from the above mentioned databases, MIRit uses the
\code{geneset} R package. Moreover, to perform ORA, MIRit implements the
\code{fgsea} package in Bioconductor.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# perform enrichment analysis of integrated targets with DO
targets_enrichment <- enrichTargets(obj, database = "DO")

}
\references{
Liu, Y., Li, G. Empowering biologists to decode omics data: the Genekitr R
package and web server. BMC Bioinformatics 24, 214 (2023).
\url{https://doi.org/10.1186/s12859-023-05342-9}.

Korotkevich G, Sukhov V, Sergushichev A (2019). “Fast gene set enrichment
analysis.” bioRxiv. doi:10.1101/060012,
\url{http://biorxiv.org/content/early/2016/06/20/060012}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
