% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{significantAccessors}
\alias{significantAccessors}
\alias{significantMirnas}
\alias{significantGenes}
\title{Get the IDs of statistically differentially expressed miRNAs/genes}
\usage{
significantMirnas(object)

significantGenes(object)
}
\arguments{
\item{object}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing
miRNA and gene data}
}
\value{
A \code{character} vector of miRNA IDs (e.g. 'hsa-miR-16-5p',
hsa-miR-29a-3p'...), or a\code{character} vector of gene symbols (e.g. 'TP53',
'FOXP2', 'TIGAR', CASP1'...).
}
\description{
The \code{significantMirnas()} and \code{significantGenes()} functions access the
\code{significant} features contained in the \code{mirnaDE} or \code{geneDE} slots
of a \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object, and can be used
to obtain the IDs of statistically differentially expressed miRNAs and genes.
}
\section{Functions}{
\itemize{
\item \code{significantMirnas()}: Get the IDs of differentially expressed
miRNAs

\item \code{significantGenes()}: Get the IDs of differentially expressed
genes

}}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# extract significant DE-miRNAs
sigMirnas <- significantMirnas(obj)

# extract significant DEGs
sigGenes <- significantGenes(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
