% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/lrtest.R
\name{LRT}
\alias{LRT}
\alias{LRT,SingleCellAssay,character-method}
\title{Likelihood Ratio Tests for SingleCellAssays}
\usage{
LRT(sca, comparison, ...)

\S4method{LRT}{SingleCellAssay,character}(sca, comparison, referent = NULL, groups = NULL, returnall = FALSE)
}
\arguments{
\item{sca}{A \code{SingleCellAssay} class object}

\item{comparison}{A \code{character} specifying the factor for comparison}

\item{...}{ignored}

\item{referent}{A \code{character} specifying the reference level of \code{comparison}.}

\item{groups}{A optional \code{character} specifying a variable on which to stratify the test.  For each level of \code{groups}, there will be a separate likelihood ratio test.}

\item{returnall}{A \code{logical} specifying if additional rows should be returned with information about the different components of the test.}
}
\value{
\code{data.frame}
}
\description{
Tests for a change in ET binomial proportion or mean of positive ET
Likelihood Ratio Test for SingleCellAssay objects
}
\details{
Combined Likelihood ratio test (binomial and normal) for SingleCellAssay and derived objects.
This function is deprecated, please use \link{lrTest} instead.
}
\examples{
data(vbetaFA)
LRT(vbetaFA, 'Stim.Condition', 'Unstim')
}
\seealso{
zlm ZlmFit
}
