% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAGenomicSignatures-methods.R
\name{PCAGenomicSignatures-methods}
\alias{PCAGenomicSignatures-methods}
\alias{studies<-}
\alias{silhouetteWidth<-}
\alias{gsea<-}
\alias{trainingData<-}
\alias{mesh<-}
\alias{PCAsummary<-}
\alias{studies}
\alias{silhouetteWidth}
\alias{gsea}
\alias{trainingData}
\alias{mesh}
\alias{PCAsummary}
\alias{studies<-,PCAGenomicSignatures-method}
\alias{silhouetteWidth<-,PCAGenomicSignatures-method}
\alias{gsea<-,PCAGenomicSignatures-method}
\alias{trainingData<-,PCAGenomicSignatures-method}
\alias{mesh<-,PCAGenomicSignatures-method}
\alias{PCAsummary<-,PCAGenomicSignatures-method}
\alias{studies,PCAGenomicSignatures-method}
\alias{silhouetteWidth,PCAGenomicSignatures-method}
\alias{gsea,PCAGenomicSignatures-method}
\alias{trainingData,PCAGenomicSignatures-method}
\alias{mesh,PCAGenomicSignatures-method}
\alias{PCAsummary,PCAGenomicSignatures-method}
\alias{show,PCAGenomicSignatures-method}
\title{Methods and accesors for \code{PCAGenomicSignatures} object}
\usage{
\S4method{studies}{PCAGenomicSignatures}(x) <- value

\S4method{silhouetteWidth}{PCAGenomicSignatures}(x) <- value

\S4method{gsea}{PCAGenomicSignatures}(x) <- value

\S4method{trainingData}{PCAGenomicSignatures}(x) <- value

\S4method{mesh}{PCAGenomicSignatures}(x) <- value

\S4method{PCAsummary}{PCAGenomicSignatures}(x) <- value

\S4method{studies}{PCAGenomicSignatures}(x)

\S4method{silhouetteWidth}{PCAGenomicSignatures}(x)

\S4method{gsea}{PCAGenomicSignatures}(x)

\S4method{trainingData}{PCAGenomicSignatures}(x)

\S4method{mesh}{PCAGenomicSignatures}(x)

\S4method{PCAsummary}{PCAGenomicSignatures}(x)

\S4method{show}{PCAGenomicSignatures}(object)
}
\arguments{
\item{value}{See details.}

\item{object, x}{A \code{PCAGenomicSignatures} object}
}
\value{
PCAGenomicSignatures object with multiple setters or accessors
}
\description{
The default contents of \code{PCAGenomicSignatures} object, with
a set of accessor and setter generic functions, which extract either the
\code{assay}, \code{colData}, \code{metadata}, or \code{trainingData} slots
of a \code{\link{PCAGenomicSignatures-class}} object. When you create this
object, \code{colData$studies} should be populated before adding any
information in \code{trainingData} slot
}
\details{
\itemize{
    \item RAVindex(x) : RAVindex (= avgLoadings) containing genes x RAVs
    \item metadata(x)$cluster : A vector of integers (from 1:k) indicating
    the cluster to which each PC is allocated.
    \item metadata(x)$size : The number of PCs in each cluster.
    \item metadata(x)$k : The number of RAVs.
    \item metadata(x)$n : The number of top PCs from each dataset.
    \item metadata(x)$geneSets : Name of the prior gene sets used to annotate
    average loadings.
    \item colData(x)$studies : A list of character vectors containing studies
    contributing to each PC cluster.
    \item colData(x)$gsea : A list of data frames. Each element is a subset
    of outputs from \code{clusterProfiler::GSEA} function.
}
}
\section{Slots}{

\describe{
\item{\code{trainingData}}{A \code{\link[S4Vectors]{DataFrame}} class object for
metadata associated with training data}
}}

\section{Setters}{

Setter method values (i.e., \code{function(x) <- value}):
\itemize{
    \item geneSets<- : A character vector containing the name of gene sets
    used to annotate average loadings
    \item studies<- : A list of character vectors containing gene sets used
    to annotate average loadings
    \item gsea<- : A list of \code{gseaResult} objects.
    \item metadata<- : A \code{list} object of metadata
    \item `$<-` : A vector to replace the indicated column in \code{colData}
}
}

\section{Accessors}{

All the accessors inherited from \code{SummarizedExperiment} are available
and the additional accessors for \code{PCAGenomicSignatures} specific data
are listed below.
\itemize{
   \item RAVindex : Equivalent to the \code{assay(x)}
   \item geneSets : Access the \code{metadata(x)$geneSets} slot
   \item studies : Access the \code{colData(x)$studies} slot
   \item gsea : Access the \code{colData(x)$gsea}
   \item `$` : Access a column in \code{colData}
   \item trainingData : Access the \code{trainingData} slot
   \item mesh : Access the \code{trainingData(x)$MeSH} slot
   \item PCAsummary : Access the \code{trainingData(x)$PCAsummary} slot
}
}

\examples{
data(miniRAVmodel)
miniRAVmodel

}
