% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexTrack.R
\docType{class}
\name{DuplexTrack}
\alias{DuplexTrack}
\title{class for the visualization of RNA duplexes}
\arguments{
\item{gi}{An \code{GInteractions} object}

\item{gr_region}{\code{GRanges} region for plotting}

\item{from}{Integer start coordinate of subset region. Used if \code{gr_region} is not provided}

\item{to}{Integer end coordinate of subset region. Used if \code{gr_region} is not provided}

\item{chromosome}{Chromosome of subset region. Used if \code{gr_region} is not provided}

\item{strand}{Used if \code{gr_region} is not provided}

\item{fill.column}{used for fill. Default is "" (empty) and triggers IGV color pallete.
\strong{Display parameters}
\describe{
\item{arcs.color}{Character. Color of the arcs. Default is "black".}
\item{arc.location}{Character in c('inner','outer','midpoint'). Location of the arcs in X axis relative to range.
Default is "inner"}
\item{labels.v.offset.base}{Numeric. Base vertical offset for the labels. Default is 0.2. Other offesets are added to it.
}
\item{labels.v.offset.trans}{Numeric. Vertical offset for trans labels. Applied when one part of the duplex is outside of the plot.
Recommended ranges are in -0.5 to 0.5 Default is 0.0.   }
\item{labels.h.offset.trans}{Numeric. Horizontal offset for trans labels.
Applied when one part of the duplex is outside of the plot
Value is in nucleotide units. Default is 0.0. }
\item{labels.v.offset.cis}{Numeric. Vertical offset for cis labels.  Recommended ranges are in -0.5 to 0.5 Default is 0.0. Default is 0.0. }
\item{labels.h.offset.cis}{Numeric. Horizontal offset for cis labels.  Value is in nucleotide units. Default is 0.0.}
\item{labels.fontsize}{Numeric. Font size of the labels. Default is 18.}
\item{label.cis.above}{Logical. Whether the cis labels should be above. When set to FALSE, labels are plot for each box separately.
Default is TRUE}
\item{annotation.column1}{Character. First annotation column to use for labels. Default is "group" and generated internally.}
\item{annotation.column2}{Character. Second annotation column to use for labels. Default is "" (empty).}
\item{fill.column}{Character. Column used for fill. Default is "" (empty) and triggers IGV color pallete.}
\item{labels.color}{Character. Color of the labels. Default is 'black'.}
\item{labels.align}{Character. Alignment of the labels. Default is 'center'.
Possible values are in c('left','right','center)}
\item{arcConstrain}{Numeric. Minimum gap distance between arms of the
interaction to draw arcs}
}}
}
\description{
Inherits the \code{Gviz::AnnotationTrack}, plots interaction ranges as boxes.
Arguments from \code{Gviz::AnnotationTrack}, as \code{stacking} which set boxes
layout are accepted. Parent aesthetics for labels are overwritten with Display
parameters of this class.
Accepts \code{GInteractions} object to plot and \code{GRanges} to define plot region

Duplexes which can be displayed on the plot range are connected with arcs.
Duplexes which are partially outside of the range are displayed without arcs.
Labeles and appearance can be controlled with display parameters
}
\examples{
library(InteractionSet)
library(Gviz)
# generate input
anchor1 <- GRanges(
    seqnames = "chr1",
    ranges = IRanges(
        start = c(100, 600, 1100, 1600, 2100, 150, 400),
        end = c(200, 700, 1200, 1700, 2200, 250, 500)
    ),
    strand = "+"
)
anchor2 <- GRanges(
    seqnames = "chr1",
    ranges = IRanges(
        start = c(300, 800, 1300, 1800, 2300, 1500, 1700),
        end = c(400, 900, 1400, 1900, 2400, 1600, 1800)
    ),
    strand = "+"
)

interactions <- GInteractions(anchor1, anchor2, mode = "strict")
# define plotting range
gr_region <- range(anchor1, anchor2)
interactions$anno_A <- sample(LETTERS, length(interactions))
interactions$anno_B <- interactions$anno_A
a <- DuplexTrack(interactions, gr_region = gr_region, stacking = "dense")
plotTracks(a, stacking = "dense")
plotTracks(a, stacking = "squish", annotation.column1 = "anno_A")

# add interactions which are not fully in plot range: outside the range or on different chromosome()

# one left (A) interaction arm outside of the plot, other on different chromosome
new_anchor1 <- GRanges(
    seqnames = c("chr1", "chr2"),
    ranges = IRanges(
        start = c(10, 600),
        end = c(90, 700)
    ),
    strand = "+"
)
new_anchor2 <- GRanges(
    seqnames = c("chr1", "chr1"),
    ranges = IRanges(
        start = c(1500, 1000),
        end = c(1600, 1200)
    ),
    strand = "+"
)

new_interactions <- GInteractions(new_anchor1, new_anchor2)
new_interactions$anno_A <- c("A.out", "A.out_chr")
new_interactions$anno_B <- c("B.in", "B.in")
all_interactions <- c(interactions, new_interactions)

b <- DuplexDiscovereR::DuplexTrack(all_interactions,
    gr_region = gr_region,
    annotation.column1 = "anno_A",
    annotation.column2 = "anno_B"
)

plotTracks(b)

# to customize plot, one can call, to see options
DuplexDiscovereR::availableDisplayPars(b)

}
