% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{poolTwoMethylationDatasets}
\alias{poolTwoMethylationDatasets}
\title{Pool two methylation datasets}
\usage{
poolTwoMethylationDatasets(
  methylationData1,
  methylationData2,
  sample1_name = NULL,
  sample2_name = NULL
)
}
\arguments{
\item{methylationData1}{a \code{\link{GRanges}} object with the methylation
data (see \code{\link{methylationDataList}}).}

\item{methylationData2}{a \code{\link{GRanges}} object with the methylation
data (see \code{\link{methylationDataList}}).}

\item{sample1_name}{the label used for sample 1.}

\item{sample2_name}{the label used for sample 2.}
}
\value{
the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).
If the Granges are from ONT datasets, its have six metedata columns include as
ONT_Cm and ONT_C (see \code{\link{readONTbam}}).
}
\description{
This function pools together two methylation datasets.
}
\examples{
# load methylation data object
data(methylationDataList)

# save the two datasets together
pooledMethylationData <- poolTwoMethylationDatasets(methylationDataList[[1]],
                         methylationDataList[[2]])

}
\author{
Nicolae Radu Zabet updated by Young Jun Kim
}
