\name{get_honeycombs}
\alias{get_honeycombs}
\title{Generate honycomb plot: visualize community occupancy of pairs of immune 
receptor repertoires}
\description{
Use the \code{community_occupancy_matrix} generated by the function 
\code{detect_communities} to generate honeycomb plots for each pair of
repertoires. In each plot, we will show communities (rows in the matric
\code{community_occupancy_matrix}) as dots and their intensities in a
pair of repertoires (x-axis and y-axis). The density of dots is encoded
by the color of the honeycomb-like hexagons.
}
\details{
Use the \code{community_occupancy_matrix} generated by the function 
\code{detect_communities} to generate honeycomb plots for each pair of
repertoires. In each plot, we will show communities (rows in the matric
\code{community_occupancy_matrix}) as dots and their intensities in a
pair of repertoires (x-axis and y-axis). The density of dots is encoded
by the color of the honeycomb-like hexagons.
}
\usage{
get_honeycombs(com)
}
\arguments{
\item{com}{\code{community_occupancy_matrix}, matrix generated by 
\code{detect_communities}}
}
\value{
The output is a list with ggplots. Given n repertoires (columns in input
\code{community_occupancy_matrix}), it will generate n*(n-1)/2 plots.
You can arrange the ggplots (or a portion of them) in any shape e.g. with 
the R-package patchwork.
}
\examples{
# load package input data
data("CDR3ab", package = "ClustIRR")
a <- data.frame(CDR3a = CDR3ab[1:300, "CDR3a"],
                CDR3b = CDR3ab[1:300, "CDR3b"],
                clone_size = 1,
                sample = "a")

b <- data.frame(CDR3a = CDR3ab[201:400, "CDR3a"],
                  CDR3b = CDR3ab[201:400, "CDR3b"],
                  clone_size = 1,
                  sample = "b")
b$clone_size[1] <- 20

# run ClustIRR analysis
c <- clustirr(s = rbind(a, b))

# detect communities
gcd <- detect_communities(graph = c$graph, 
                          algorithm = "leiden",
                          resolution = 1,
                          weight = "ncweight",
                          chains = c("CDR3a", "CDR3b"))

# get honeycombs
g <- get_honeycombs(com = gcd$community_occupancy_matrix)

g
}
