% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCfunctions.R
\name{withinSampleDoublets}
\alias{withinSampleDoublets}
\title{withinSampleDoublets}
\usage{
withinSampleDoublets(sce, altExp_name = NULL, eps = 200, minPts = 50)
}
\arguments{
\item{sce}{a SingleCellExperiment}

\item{altExp_name}{expression name of HTO matrix}

\item{eps}{eps of DBSCAN}

\item{minPts}{minPts of DBSCAN}
}
\value{
A SingleCellExperiment object
}
\description{
doublet identification within batch
}
\examples{

data(CITEseq_example, package = "CiteFuse")
sce_citeseq <- preprocessing(CITEseq_example)
sce_citeseq <- normaliseExprs(sce = sce_citeseq,
altExp_name = "HTO",
transform = "log")
sce_citeseq <- crossSampleDoublets(sce_citeseq)
sce_citeseq <- withinSampleDoublets(sce_citeseq,
minPts = 10)

}
