% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCfunctions.R
\name{crossSampleDoublets}
\alias{crossSampleDoublets}
\title{crossSampleDoublets}
\usage{
crossSampleDoublets(sce, altExp_name = NULL, totalExp_threshold = 10)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{altExp_name}{Name of alternative expression that will be
used to perform normalisation.
If it is NULL, it will set to HTO.}

\item{totalExp_threshold}{the threshold indicates for the HTO
less than this threshold
will be filtered from the analysis}
}
\value{
A SingleCellExperiment Object
}
\description{
A function that perform normalisation for alternative expression
}
\examples{
data(CITEseq_example, package = "CiteFuse")
sce_citeseq <- preprocessing(CITEseq_example)
sce_citeseq <- normaliseExprs(sce = sce_citeseq,
altExp_name = "HTO",
transform = "log")
sce_citeseq <- crossSampleDoublets(sce_citeseq)

}
