test_that("ChromBackendMzR works", {
    expect_true(isReadOnly(be_mzr))
    expect_false(be_mzr@inMemory)
    expect_false(identical(peaksData(be_mzr),.peaksData(be_mzr)))
    expect_true(identical(length(peaksData(be_mzr)), length(.peaksData(be_mzr))))
    expect_true(identical(
        chromData(be_mzr),
        fillCoreChromVariables(.chromData(be_mzr))
    ))
    expect_false(supportsSetBackend(be_mzr))
})

test_that("backendInitialize works", {
    expect_equal(
        backendInitialize(ChromBackendMzR(), files = character()),
        ChromBackendMzR()
    )
    expect_error(
        backendInitialize(ChromBackendMzR(), files = numeric(2)),
        "must be"
    )
})

test_that("show method for ChromBackendMzR works correctly", {
    expect_output(show(be_mzr), "file")
    expect_output(show(be_mzr), "138 chromatograms")
    expect_output(show(be_mzr), "chromIndex")
    expect_output(show(be_mzr), "msLevel")
    expect_output(show(be_mzr), "mz")
    tmp <- be_mzr
    tmp@inMemory <- TRUE
    expect_output(show(tmp), "Peaks data is cached in memory")
})

test_that("replacement method works", {
    tmp <- be_mzr
    peaksData(tmp)[[1]] <- peaksData(be_mzr)[[1]] + 1
    expect_false(identical(peaksData(tmp)[[1]], peaksData(be_mzr)[[1]]))
    expect_true(identical(peaksData(tmp)[[1]], peaksData(be_mzr)[[1]] + 1))
    expect_true(.inMemory(tmp))
    expect_false(.inMemory(be_mzr))

    cd <- chromData(tmp)
    cd$mz <- 1
    expect_true(!identical(chromData(tmp), cd))
    chromData(tmp) <- cd
    expect_equal(chromData(tmp), cd)
})

test_that("backendParallelFactor works", {
    expect_equal(levels(backendParallelFactor(be_mzr)), unique(dataOrigin(be_mzr)))
})

test_that("error message work", {
    expect_error(
        peaksData(be_mzr, columns = "notacolumn"),
        "requested peaks variables"
    )
})
