% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chromatograms-peaksData.R
\name{peaksData}
\alias{peaksData}
\alias{peaksVariables}
\alias{filterPeaksData}
\alias{peaksData,Chromatograms-method}
\alias{peaksData<-,Chromatograms-method}
\alias{peaksVariables,Chromatograms-method}
\alias{rtime,Chromatograms-method}
\alias{rtime<-,Chromatograms-method}
\alias{intensity,Chromatograms-method}
\alias{intensity<-,Chromatograms-method}
\alias{filterPeaksData,Chromatograms-method}
\title{Chromatographic peaks data}
\usage{
\S4method{peaksData}{Chromatograms}(
  object,
  columns = peaksVariables(object),
  f = processingChunkFactor(object),
  BPPARAM = bpparam(),
  drop = FALSE,
  ...
)

\S4method{peaksData}{Chromatograms}(object) <- value

\S4method{peaksVariables}{Chromatograms}(object, ...)

\S4method{rtime}{Chromatograms}(object, ...)

\S4method{rtime}{Chromatograms}(object) <- value

\S4method{intensity}{Chromatograms}(object, ...)

\S4method{intensity}{Chromatograms}(object) <- value

\S4method{filterPeaksData}{Chromatograms}(
  object,
  variables = character(),
  ranges = numeric(),
  match = c("any", "all"),
  keep = TRUE
)
}
\arguments{
\item{object}{A \link{Chromatograms} object.}

\item{columns}{For \code{peaksData()}: optional \code{character} with column
names (peaks variables) that should be included in the
returned \code{list} of \code{data.frame}. By default, all columns are returned.
Available variables can be found by calling \code{peaksVariables()} on the
object.}

\item{f}{\code{factor} defining the grouping to split the \code{Chromatograms} object.}

\item{BPPARAM}{Parallel setup configuration. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for more information.}

\item{drop}{\code{logical(1)} For \code{peaksData()}, default to \code{FALSE}. If \code{TRUE},
and one column is called by the user, the method returns a list of
vector of the single column requested.}

\item{...}{Additional arguments passed to the method.}

\item{value}{For \code{rtime()} and \code{intensity()}: \code{numeric} vector with the
values to replace the current values. The length of the vector must
match the number of peaks data pairs in the \code{Chromatograms} object.}

\item{variables}{For \code{filterPeaksData()}: \code{character} vector with the names
of the peaks data variables to filter for. The list of available
peaks data variables can be obtained with \code{peaksVariables()}.}

\item{ranges}{For \code{filterPeaksData()} : a \code{numeric} vector of paired values
(upper and lower boundary) that define the ranges to filter the
\code{object}. These paired values need to be in the same order as the
\code{variables} parameter (see below).}

\item{match}{For \code{filterPeaksData()} : \code{character(1) } defining whether the
condition has to match for all provided \code{ranges} (\code{match = "all"};
the default), or for any of them (\code{match = "any"}).}

\item{keep}{For \code{filterPeaksData()}: \code{logical(1)} defining whether to
keep (\code{keep = TRUE}) or remove (\code{keep = FALSE}) the chromatographic
peaks data that match the condition.}
}
\value{
Refer to the individual function description for information on the
return value.
}
\description{
As explained in the \link{Chromatograms} class documentation, the \code{Chromatograms}
object is a container for chromatographic data that includes chromatographic
peaks data (\emph{retention time} and related intensity values, also referred to
as \emph{peaks data variables} in the context of \code{Chromatograms}) and metadata of
individual chromatograms (so called \emph{chromatograms variables}).

The \emph{peaks data variables} information can be accessed using the
\code{peaksData()} function. It is also possible to access specific peaks
variables using \code{$}.

The peaks data can be accessed, replaced but also filtered/subsetted. Refer
to the sections below for more details.
}
\section{Filter Peaks Variables}{


Functions that filter a \code{Chromatograms}'s peaks data (i.e., \code{peaksData}).
These functions remove peaks data that do not meet the
specified conditions. If a chromatogram in a \code{Chromatograms} object is
filtered, only the corresponding peaks variable pairs (i.e., rows) in the
\code{peaksData} are removed, while the chromatogram itself remains in the object.

The available functions to filter chromatographic peaks data include:
\itemize{
\item \code{filterPeaksData()}: Filters numerical peaks data variables based on the
specified numerical \code{ranges} parameter. This method returns the same input
\code{Chromatograms} object, but the filtering step is added to the processing
queue. The filtered data will be reflected when the user accesses
\code{peaksData}. This function does \emph{not} reduce the number of chromatograms
in the object, but it removes the specified peaks data (e.g., "rtime" and
"intensity" pairs) from the \code{peaksData}.
}

In the case of a read-only backend, (such as the \link{ChromBackendMzR}), the
replacement of the peaks data is not possible. The peaks data can be
filtered, but the filtered data will not be saved in the backend. This means
the original mzml files will not be affected by computations performed on
the \link{Chromatograms}.
}

\examples{

# Create a Chromatograms object
cdata <- data.frame(
    msLevel = c(1L, 1L, 1L),
    mz = c(112.2, 123.3, 134.4),
    chromIndex = c(1L, 2L, 3L)
)

pdata <- list(
    data.frame(
        rtime = c(12.4, 12.8, 13.2, 14.6),
        intensity = c(123.3, 153.6, 2354.3, 243.4)
    ),
    data.frame(
        rtime = c(45.1, 46.2),
        intensity = c(100, 80.1)
    ),
    data.frame(
        rtime = c(12.4, 12.8, 13.2, 14.6),
        intensity = c(123.3, 153.6, 2354.3, 243.4)
    )
)

be <- backendInitialize(new("ChromBackendMemory"),
    chromData = cdata,
    peaksData = pdata
)

chr <- Chromatograms(be)

# Access peaks data
peaksData(chr)

# Access specific peaks data variables
peaksData(chr, columns = "rtime")
rtime(chr)

# Replace peaks data
rtime(chr)[[1]] <- c(1, 2, 3, 4)

# Filter peaks data
filterPeaksData(chr, variables = "rtime", ranges = c(12.5, 13.5))

}
\seealso{
\link{Chromatograms} for a general description of the \code{Chromatograms}
object, and \link{chromData} for accessing,substituting and filtering
chromatographic variables. For more information on the queuing
of processings and parallelization for larger dataset processing
see \link{processingQueue}.
}
\author{
Philippine Louail
}
