% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChromBackend-functions.R, R/ChromBackend.R
\name{coreChromVariables}
\alias{coreChromVariables}
\alias{corePeaksVariables}
\alias{ChromBackend}
\alias{ChromBackend-class}
\alias{ChromBackendMemory-class}
\alias{ChromBackendMzR-class}
\alias{ChromBackendSpectra-class}
\alias{[,ChromBackend-method}
\alias{[[,ChromBackend-method}
\alias{[[<-,ChromBackend-method}
\alias{extractByIndex}
\alias{factorize}
\alias{$,ChromBackend-method}
\alias{$<-,ChromBackend-method}
\alias{backendMerge,ChromBackend-method}
\alias{chromData,ChromBackend-method}
\alias{chromData<-,ChromBackend-method}
\alias{factorize,ChromBackend-method}
\alias{peaksData,ChromBackend-method}
\alias{peaksData<-,ChromBackend-method}
\alias{backendBpparam,ChromBackend-method}
\alias{backendInitialize,ChromBackend-method}
\alias{backendParallelFactor,ChromBackend-method}
\alias{backendMerge,list-method}
\alias{chromIndex,ChromBackend-method}
\alias{chromIndex<-,ChromBackend-method}
\alias{chromVariables,ChromBackend-method}
\alias{collisionEnergy,ChromBackend-method}
\alias{collisionEnergy<-,ChromBackend-method}
\alias{dataOrigin,ChromBackend-method}
\alias{dataOrigin<-,ChromBackend-method}
\alias{extractByIndex,ChromBackend,ANY-method}
\alias{extractByIndex,ChromBackend,missing-method}
\alias{intensity,ChromBackend-method}
\alias{intensity<-,ChromBackend-method}
\alias{isEmpty,ChromBackend-method}
\alias{isReadOnly,ChromBackend-method}
\alias{length,ChromBackend-method}
\alias{lengths,ChromBackend-method}
\alias{msLevel,ChromBackend-method}
\alias{msLevel<-,ChromBackend-method}
\alias{mz,ChromBackend-method}
\alias{mz<-,ChromBackend-method}
\alias{mzMax,ChromBackend-method}
\alias{mzMax<-,ChromBackend-method}
\alias{mzMin,ChromBackend-method}
\alias{mzMin<-,ChromBackend-method}
\alias{peaksVariables,ChromBackend-method}
\alias{precursorMz,ChromBackend-method}
\alias{precursorMz<-,ChromBackend-method}
\alias{precursorMzMax,ChromBackend-method}
\alias{precursorMzMax<-,ChromBackend-method}
\alias{precursorMzMin,ChromBackend-method}
\alias{precursorMzMin<-,ChromBackend-method}
\alias{productMz,ChromBackend-method}
\alias{productMz<-,ChromBackend-method}
\alias{productMzMax,ChromBackend-method}
\alias{productMzMax<-,ChromBackend-method}
\alias{productMzMin,ChromBackend-method}
\alias{productMzMin<-,ChromBackend-method}
\alias{reset,ChromBackend-method}
\alias{rtime,ChromBackend-method}
\alias{rtime<-,ChromBackend-method}
\alias{split,ChromBackend,ANY-method}
\alias{filterChromData,ChromBackend-method}
\alias{filterPeaksData,ChromBackend-method}
\alias{supportsSetBackend,ChromBackend-method}
\title{Chromatographic MS Data Backends}
\usage{
coreChromVariables()

corePeaksVariables()

\S4method{$}{ChromBackend}(x, name)

\S4method{$}{ChromBackend}(x, name) <- value

\S4method{backendMerge}{ChromBackend}(object, ...)

\S4method{chromData}{ChromBackend}(object, columns = chromVariables(object), drop = FALSE)

\S4method{chromData}{ChromBackend}(object) <- value

\S4method{factorize}{ChromBackend}(object, ...)

\S4method{peaksData}{ChromBackend}(object, columns = c("rtime", "intensity"), drop = FALSE, ...)

\S4method{peaksData}{ChromBackend}(object) <- value

\S4method{[}{ChromBackend}(x, i, j, ..., drop = FALSE)

\S4method{[[}{ChromBackend}(x, i, j, ...)

\S4method{[[}{ChromBackend}(x, i, j, ...) <- value

\S4method{backendBpparam}{ChromBackend}(object, BPPARAM = bpparam())

\S4method{backendInitialize}{ChromBackend}(object, ...)

\S4method{backendParallelFactor}{ChromBackend}(object, ...)

\S4method{backendMerge}{list}(object, ...)

\S4method{chromIndex}{ChromBackend}(object)

\S4method{chromIndex}{ChromBackend}(object) <- value

\S4method{chromVariables}{ChromBackend}(object)

\S4method{collisionEnergy}{ChromBackend}(object)

\S4method{collisionEnergy}{ChromBackend}(object) <- value

\S4method{dataOrigin}{ChromBackend}(object)

\S4method{dataOrigin}{ChromBackend}(object) <- value

\S4method{extractByIndex}{ChromBackend,ANY}(object, i)

\S4method{extractByIndex}{ChromBackend,missing}(object, i)

\S4method{intensity}{ChromBackend}(object)

\S4method{intensity}{ChromBackend}(object) <- value

\S4method{isEmpty}{ChromBackend}(x)

\S4method{isReadOnly}{ChromBackend}(object)

\S4method{length}{ChromBackend}(x)

\S4method{lengths}{ChromBackend}(x)

\S4method{msLevel}{ChromBackend}(object)

\S4method{msLevel}{ChromBackend}(object) <- value

\S4method{mz}{ChromBackend}(object)

\S4method{mz}{ChromBackend}(object) <- value

\S4method{mzMax}{ChromBackend}(object)

\S4method{mzMax}{ChromBackend}(object) <- value

\S4method{mzMin}{ChromBackend}(object)

\S4method{mzMin}{ChromBackend}(object) <- value

\S4method{peaksVariables}{ChromBackend}(object)

\S4method{precursorMz}{ChromBackend}(object)

\S4method{precursorMz}{ChromBackend}(object) <- value

\S4method{precursorMzMax}{ChromBackend}(object)

\S4method{precursorMzMax}{ChromBackend}(object) <- value

\S4method{precursorMzMin}{ChromBackend}(object)

\S4method{precursorMzMin}{ChromBackend}(object) <- value

\S4method{productMz}{ChromBackend}(object)

\S4method{productMz}{ChromBackend}(object) <- value

\S4method{productMzMax}{ChromBackend}(object)

\S4method{productMzMax}{ChromBackend}(object) <- value

\S4method{productMzMin}{ChromBackend}(object)

\S4method{productMzMin}{ChromBackend}(object) <- value

\S4method{reset}{ChromBackend}(object)

\S4method{rtime}{ChromBackend}(object)

\S4method{rtime}{ChromBackend}(object) <- value

\S4method{split}{ChromBackend,ANY}(x, f, drop = FALSE, ...)

\S4method{filterChromData}{ChromBackend}(
  object,
  variables = character(),
  ranges = numeric(),
  match = c("any", "all"),
  keep = TRUE
)

\S4method{filterPeaksData}{ChromBackend}(
  object,
  variables = character(),
  ranges = numeric(),
  match = c("any", "all"),
  keep = TRUE
)

\S4method{supportsSetBackend}{ChromBackend}(object, ...)
}
\arguments{
\item{x}{Object extending \code{ChromBackend}.}

\item{name}{For \code{$} and \verb{$<-}: the name of the chromatogram variable to
return or set.}

\item{value}{Replacement value for \verb{<-} methods. See individual
method description or expected data type.}

\item{object}{Object extending \code{ChromBackend}.}

\item{...}{Additional arguments.}

\item{columns}{For \code{chromData()} accessor: optional \code{character} with column
names (chromatogram variables) that should be included in the
returned \code{data.frame}. By default, all columns are returned.}

\item{drop}{For \code{chromData()} and \code{peaksData()}: \code{logical(1)} default to
\code{FALSE}. If \code{TRUE}, and one column is requested by the user, the
method should return a vector (or list of vector for \code{peaksData()})
of the single column requested.}

\item{i}{For \code{[}: \code{integer}, \code{logical} or \code{character} to subset the object.}

\item{j}{For \code{[} and \code{[[}: ignored.}

\item{BPPARAM}{Parallel setup configuration. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for more information.}

\item{f}{\code{factor} defining the grouping to split \code{x}. See \code{\link[=split]{split()}}.}

\item{variables}{For \code{filterChromData()}: \code{character} vector with the names
of the chromatogram variables to filter for. The list of available
chromatogram variables can be obtained with \code{chromVariables()}.}

\item{ranges}{For \code{filterChromData()} : a \code{numeric}
vector of paired values (upper and lower boundary) that define the
ranges to filter the \code{object}. These paired values need to be in the
same order as the \code{variables} parameter (see below).}

\item{match}{For \code{filterChromData()} : \code{character(1) }
defining whether the condition has to match for all provided
\code{ranges} (\code{match = "all"}; the default), or for any of them
(\code{match = "any"}) for chromatogram data to be retained.}

\item{keep}{For \code{filterChromData()}: \code{logical(1)}
defining whether to keep (\code{keep = TRUE}) or remove (\code{keep = FALSE})
the chromatogram data that match the condition.}
}
\value{
Refer to the individual function description for information on the
return value.
}
\description{
\code{ChromBackend} is a virtual class that defines what different backends need
to provide to be used by the \code{Chromatograms} package and classes.

The backend should provide access to the chromatographic data which mainly
consists of (paired) intensity and retention time values. Additional
chromatographic metadata such as MS level and precursor and product m/z
should also be provided.

Through their implementation different backends can be either optimized for
minimal memory requirements or performance. Each backend needs to implement
data access methods listed in section \emph{Backend functions:} below.

And example implementation and more details and descriptions are provided
in the \emph{Creating new \code{ChromBackend} classes for Chromatograms} vignette.

Currently available backends are:
\itemize{
\item \code{ChromBackendMemory}: This backend stores chromatographic data directly
in memory, making it ideal for small datasets or testing. It can be
initialized with a \code{data.frame} of chromatographic data via the
\code{chromData} parameter and a \code{list} of \code{data.frame} entries for peaks data
using the \code{peaksData} parameter. These data can be accessed with the
\code{chromData()} and \code{peaksData()} functions.
\item \code{ChromBackendMzR}: The \code{ChromBackendMzR} inherits all slots and methods
from the base \code{ChromBackendMemory} backend, providing additional
functionality for reading chromatographic data from mzML files.
\item \code{ChromBackendSpectra}: The \code{ChromBackendSpectra} inherits all slots and
methods from the base \code{ChromBackendMemory} backend, providing additional
functionality for reading chromatographic data from \code{Spectra} objects.
}

Filter the peak data based on the provided ranges for the given variables.
}
\note{
This function replaces the peaksData() of the input object. Therefore
backend with \code{readOnly == TRUE} (i.e. ChromBackendmzR) will need to have a
carefully implemented \verb{peaksData(object) <-} method.
}
\section{Core chromatogram variables}{


The \emph{core} chromatogram variables are variables (metadata) that can/should
be provided by a backend. For each of these variables a value needs to be
returned, if none is defined, a missing value (of the correct data type)
should be returned. The names of the chromatogram variables in your current
chromatogram object are returned with the \code{chromVariables()} function.

For each core chromatogram variable a dedicated access method exists. In
contrast to the peaks data described below, a single value should be
returned for each chromatogram.

The \code{coreChromVariables()} function returns the core chromatogram variables
along with their expected (defined) data type.

The core chromatogram variables (in alphabetical order) are:
\itemize{
\item \code{chromIndex}: an \code{integer} with the index of the chromatogram in the
original source file (e.g. \emph{mzML} file).
\item \code{collisionEnergy}: for SRM data, \code{numeric} with the collision energy of
the precursor.
\item \code{dataOrigin}: optional \code{character} with the origin of a chromatogram.
\item \code{dataOrigin}: \code{character} defining where the data is (currently) stored.
\item \code{msLevel}: \code{integer} defining the MS level of the data.
\item \code{mz}: optional \code{numeric} with the (target) m/z value for the
chromatographic data.
\item \code{mzMin}: optional \code{numeric} with the lower m/z value of the m/z range in
case the data (e.g. an extracted ion chromatogram EIC) was extracted from
a \code{Spectra} object.
\item \code{mzMax}: optional \code{numeric} with the upper m/z value of the m/z range.
\item \code{precursorMz}: for SRM data, \code{numeric} with the target m/z of the
precursor (parent).
\item \code{precursorMzMin}: for SRM data, optional \code{numeric} with the lower m/z of
the precursor's isolation window.
\item \code{precursorMzMax}: for SRM data, optional \code{numeric} with the upper m/z of
the precursor's isolation window.
\item \code{productMz} for SRM data, \code{numeric} with the target m/z of the
product ion.
\item \code{productMzMin}: for SRM data, optional \code{numeric} with the lower m/z of
the product's isolation window.
\item \code{productMzMax}: for SRM data, optional \code{numeric} with the upper m/z of
the product's isolation window.
}
}

\section{Core Peaks variables}{


Similar to the \emph{core} chromatogram variables, \emph{core} peaks variables
represent  metadata that should be provided by a backend. Each of these
variables should return a value, and if undefined, a missing value (with the
appropriate data type) is returned. The number of values for a peaks
variable in a single chromatogram can vary, from none to multiple, and may
differ between chromatograms.

The names of peaks variables in the current chromatogram object can be
obtained with the \code{peaksVariables()} function.

Each core peaks variable has a dedicated accessor method.

The \code{corePeaksVariables()} function returns the core peaks variables along
with their expected (defined) data type.

The core peaks variables, listed in the required order for \code{peaksData}, are:
\itemize{
\item \code{rtime}: A \code{numeric} vector containing retention time values.
\item \code{intensity}: A \code{numeric} vector containing intensity values.
}

They should be provided for each chromatogram in the backend,
\strong{in this order}, No NAs are allowed for the \code{rtime} values. These
characteristics will be checked with the \code{validPeaksData()} function.
}

\section{Mandatory methods}{


New backend classes \strong{must} extend the base \code{ChromBackend} class and
implement the following mandatory methods:
\itemize{
\item \code{backendInitialize()}: initialises the backend. This method is
supposed to be called right after creating an instance of the
backend class and should prepare the backend.
Parameters can be defined freely for each backend, depending on what is
needed to initialize the backend.
This method has to ensure to set the chromatogram variable \code{dataOrigin}
correctly.
\item \code{backendBpparam()}: returns the parallel processing setup supported by
the backend class. This function can be used by any higher
level function to evaluate whether the provided parallel processing
setup (or the default one returned by \code{bpparam()}) is supported
by the backend. Backends not supporting parallel processing (e.g.
because they contain a connection to a database that can not be
shared across processes) should extend this method to return only
\code{SerialParam()} and hence disable parallel processing for (most)
methods and functions. See also \code{backendParallelFactor()} for a
function to provide a preferred splitting of the backend for parallel
processing.
\item \code{backendParallelFactor()}: returns a \code{factor} defining an optimal
(preferred) way how the backend can be split for parallel processing
used for all peak data accessor or data manipulation functions.
The default implementation returns a factor of length 0 (\code{factor()})
providing thus no default splitting. \code{backendParallelFactor()} for
\code{ChromBackendMzR} on the other hand returns \code{factor(dataOrigin(object))}
hence suggesting to split the object by data file.
\item \code{chromData()}, \verb{chromData<-}: gets or sets general chromatogram metadata
(annotation). \code{chromData()} returns a \code{data.frame}, \verb{chromData<-} expects
a \code{data.frame} with the same number of rows as there are chromatograms in
\code{object}. Read-only backends might not need to implement the
replacement method \verb{chromData<-} (unless some internal caching mechanism
could be used). \code{chromData()} should be implemented with the parameter
\code{drop} set to \code{FALSE} as default. With \code{drop = FALSE} the method should
return a \code{data.frame} even if one column is requested. If \code{drop = TRUE}
is specified, the output will be a vector of the single column requested.
New backends should be implemented such as if empty, the method returns a
\code{data.frame} with 0 rows and the columns defined by \code{chromVariables()}.
By default, the function \emph{should} return at minimum the
coreChromVariables, even if NAs.
\item \code{extractByIndex()}: function to subset a backend to selected elements
defined by the provided index. Similar to \code{[}, this method should allow
extracting (or to subset) the data in any order. In contrast to \code{[},
however, \code{i} is expected to be an \code{integer} (while \code{[} should also
support \code{logical} and eventually \code{character}). While being apparently
redundant to \code{[}, this methods avoids package namespace errors/problems
that can result in implementations of \code{[} being not found by R (which
can happen sometimes in parallel processing using the
\code{\link[BiocParallel:SnowParam-class]{BiocParallel::SnowParam()}}). This method is used internally to
extract/subset its backend. Implementation of this method is mandatory.
\item \code{peaksData()}: returns a \code{list} of \code{data.frame} with the data
(e.g. retention time - intensity pairs) from each chromatogram. The length
of the \code{list} is equal to the number of chromatograms in \code{object}. For an
empty chromatogram a \code{data.frame} with 0 rows and two columns (named
\code{"rtime"} and \code{"intensity"}) has to be returned. The optional parameter
\code{columns}, if supported by the backend allows to define which peak
variables should be returned in each array. As default (minimum) columns
\code{"rtime"} and \code{"intensity"} have to be provided. \code{peaksData()} should be
implemented with the parameter \code{drop} set to \code{FALSE} as default.  With
\code{drop = FALSE} the method should return a \code{data.frame} even if only one
column is requested. If \code{drop = TRUE}  is specified, the output will be a
vector of the single column requested.
\item \verb{peaksData<-} replaces the peak data (retention time and intensity values)
of the backend. This method expects a \code{list} of two-dimensional arrays
(\code{data.frame}) with columns representing the peak variables.
All existing peaks data are expected to be replaced with these new values.
The length of the \code{list} has to match the number of chromatogram of
\code{object}. Note that only writeable backends need to support this method.
\item \code{[}: subset the backend. Only subsetting by element (\emph{row}/\code{i}) is
allowed. This method should be implemented as to support empty integer.
\item \code{$}, \verb{$<-}: access or set/add a single chromatogram variable (column) in
the backend.
\item \code{backendMerge()}: merges (combines) \code{ChromBackend} objects into a single
instance. All objects to be merged have to be of the same type.
}
}

\section{Optional methods with default implementations}{


Additional methods that might be implemented, but for which default
implementations are already present are:
\itemize{
\item \code{[[}
\item \code{backendParallelFactor()}: returns a \code{factor} defining an optimal
(preferred) way how the backend can be split for parallel processing
used for all \emph{peak} data accessor or data manipulation functions.
The default implementation returns a factor of length 0 (\code{factor()})
providing thus no default splitting.
\item \code{chromIndex()}: returns an \code{integer} vector with the index of the
chromatograms in the original source file.
\item \code{chromVariables()}: returns a \code{character} vector with the
available chromatogram variables (columns, fields or attributes)
available in \code{object}. Variables listed by this function are expected to
be returned (if requested) by the \code{chromData()} function.
\item \code{collisionEnergy()}, \verb{collisionEnergy<-}: gets or sets the collision
energy for the precursor (for SRM data). \code{collisionEnergy()} returns a
\code{numeric} of length equal to the number of chromatograms in \code{object}.
\item \code{dataOrigin()}, \verb{dataOrigin<-}: gets or sets the \emph{data origin} variable.
\code{dataOrigin()} returns a \code{character} of length equal to the number of
chromatograms, \verb{dataOrigin<-} expects a \code{character} of length equal
\code{length(object)}.
\item \code{filterChromData()}: filters any numerical chromatographic data variables
based on the provided numerical \code{ranges}. The method should return a
\code{ChromBackend} object with the chromatograms that match the condition.
This function will results in an object with less chromatogram than the
original.
\item \code{intensity()}: gets the intensity values from the chromatograms. Returns
a \code{list} of \code{numeric} vectors (intensity values for each
chromatogram). The length of the list is equal to the number of
chromatograms in \code{object}.
\item \verb{intensity<-}: replaces the intensity values. \code{value} has to be a \code{list}
of length equal to the number of chromatograms and the number of values
within each list element identical to the number of data pairs in each
chromatogram. Note that just writeable backends need to support this
method.
\item \code{isReadOnly()}: returns a \code{logical(1)} whether the backend is \emph{read
only} or does allow also to write/update data. Defaults to FALSE.
\item \code{isEmpty()}: returns a \code{logical} of length equal to the number of
chromatograms with \code{TRUE} for chromatograms without any data pairs.
\item \code{length()}: returns the number of chromatograms in the object.
\item \code{lengths()}: returns the number of data pairs (retention time and
intensity values) per chromatogram.
\item \code{msLevel()}: gets the chromatogram's MS level. Returns an \code{integer}
vector (of length equal to the number of chromatograms) with the MS
level for each chromatogram (or \code{NA_integer_} if not available).
\item \code{mz()},\verb{mz<-}: gets or sets the m/z value of the chromatograms. \code{mz()}
returns a \code{numeric} of length equal to the number of chromatograms in \code{ object}, \verb{mz<-} expects a \code{numeric} of length \code{length(object)}.
\item \code{mzMax()},\verb{mzMax<-}: gets or sets the upper m/z of the mass-to-charge
range from which a chromatogram contains signal (e.g. if the chromatogram
was extracted from MS data in spectra format and a m/z range was
provided). \code{mzMax()} returns a \code{numeric} of length equal to the number of
chromatograms in \code{object}, \verb{mzMax<-} expects a \code{numeric} of length equal
to the number of chromatograms in \code{object}.
\item \code{mzMin()},\verb{mzMin<-}: gets or sets the lower m/z of the mass-to-charge
range from which a chromatogram contains signal (e.g. if the chromatogram
was extracted from MS data in spectra format and a m/z range was
provided). \code{mzMin()} returns a \code{numeric} of length equal to the number of
chromatograms in \code{object}, \verb{mzMin<-} expects a \code{numeric} of length equal
to the number of chromatograms in \code{object}.
\item \code{peaksVariables()}: lists the available data variables for the
chromatograms. Default peak variables are \code{"rtime"} and \code{"intensity"}
(which all backends need to support and provide), but some backends
might provide additional variables.
Variables listed by this function are expected to be returned (if
requested) by the \code{peaksData()} function.
\item \code{precursorMz()},\verb{precursorMz<-}: gets or sets the (target) m/z of the
precursor (for SRM data). \code{precursorMz()} returns a \code{numeric} of length
equal to the number of chromatograms in \code{object}. \verb{precursorMz<-} expects
a \code{numeric} of length equal to the number of chromatograms.
\item \code{precursorMzMin()},\code{precursorMzMax()},\code{productMzMin()}, \code{productMzMax()}:
gets the lower and upper margin for the precursor or product isolation
windows. These functions might return the value of \code{productMz()} if the
respective minimal or maximal m/z values are not defined in \code{object}.
\item \code{productMz()},\verb{productMz<-}: gets or sets the (target) m/z of the
product (for SRM data). \code{productMz()} returns a \code{numeric} of length
equal to the number of chromatograms in \code{object}. \verb{productMz<-} expects
a \code{numeric} of length equal to the number of chromatograms.
\item \code{rtime()}: gets the retention times from the chromatograms. returns a
\code{list} of \code{numeric} vectors (retention times for each
chromatogram). The length of the returned list is equal to the number of
chromatograms in \code{object}.
\item \verb{rtime<-}: replaces the retention times. \code{value} has to be a \code{list} of
length equal to the number of chromatograms and the
number of values within each list element identical to the number of
data pairs in each chromatogram. Note that just writeable backends support
this method.
\item \code{split()}: splits the backend into a \code{list} of backends (depending on
parameter \code{f}). The default method for \code{ChromBackend} uses
\code{\link[=split.default]{split.default()}}, thus backends extending \code{ChromBackend} don't
necessarily need to implement this method.
\item \code{supportsSetBackend()}: whether a \code{ChromBackend} supports the
\code{Chromatograms} \code{setBackend()} function. The default function will
take the \code{peaksData()} and \code{chromData()} of the user's backend and pass it
to the new backend. If the backend does not support this function, it
should return \code{FALSE}. Therefore both backend in question should have a
adequate \code{peaksData()} and \code{chromData()} method as well as their
respective replacement method.
}
}

\section{Implementation notes}{


Backends extending \code{ChromBackend} \strong{must} implement all of its methods
(listed above). A guide to create new backend classes is provided as a
dedicated vignette. Additional information and an example for a backend
implementation is provided in the respective vignette.
}

\examples{

## Create a simple backend implementation
ChromBackendDummy <- setClass("ChromBackendDummy",
    contains = "ChromBackend"
)

## We will show examples on a `ChromBackendMemory` backend.
be <- ChromBackendMemory()

## The `backendInitialize()` method initializes the backend filling it with
## data. This method can take any parameters needed for the backend to
## get loaded with the data.
cdata <- data.frame(
    msLevel = c(1L, 1L, 1L),
    mz = c(112.2, 123.3, 134.4),
    chromIndex = c(1L, 2L, 3L)
)

pdata <- list(
    data.frame(
        rtime = c(12.4, 12.8, 13.2, 14.6),
        intensity = c(123.3, 153.6, 2354.3, 243.4)
    ),
    data.frame(
        rtime = c(45.1, 46.2),
        intensity = c(100, 80.1)
    ),
    data.frame(
        rtime = c(12.4, 12.8, 13.2, 14.6),
        intensity = c(123.3, 153.6, 2354.3, 243.4)
    )
)
be <- backendInitialize(be, chromData = cdata, peaksData = pdata)

be

## Data can be accessed with the accessor methods
msLevel(be)

rtime(be)

## Even if no data was provided for all chromatogram variables, its accessor
## methods are supposed to return a value.
precursorMz(be)

## The `peaksData()` method is supposed to return data/frames of rtime and
## intensity pairs as a `list`.
peaksData(be)

## Use columns to extract specific peaks variables. Below we extract rtime
## and intensity values, but in reversed order to the default.
peaksData(be, columns = c("intensity", "rtime"))

## List available chromatographic variables
chromVariables(be)

## List available peak variables
peaksVariables(be)

## Extract multiple chromatographic variables
chromData(be, c("chromIndex", "mz", "msLevel"))

## Single variables can also be accessed and replaced
mz(be)
mz(be) <- c(123.4, 134.5, 145.6)

be$msLevel
be$msLevel <- c(2L, 2L, 2L)

be[["rtime"]]
be[["rtime"]] <- list(
    c(12.4, 12.8, 13.2, 14.6),
    c(45.1, 46.2),
    c(12.4, 12.8, 13.2, 14.6)
)
}
\author{
Johannes Rainer, Philippine Louail
}
