% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{write.ygraphml}
\alias{write.ygraphml}
\alias{write.ygraphml,SingleCellExperiment-method}
\title{Export trajectory graph}
\usage{
write.ygraphml(
  sce,
  file,
  color_by = c("phenoName", "featureName"),
  name,
  node_label = "state"
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{file}{Character string naming a file}

\item{color_by}{Indicates if nodes are colorized by a feature expression
('featureName') or phenotype label ('phenoName')}

\item{name}{A character string specifying the featureName or phenoName}

\item{node_label}{Defines the node label name (optional). Can be either set
to the samples' states ('state') or the samples' names ('name').}
}
\value{
\code{write.ygraphml} returns an invisible \code{NULL}
}
\description{
Writes graphml file containing the trajectory graph's structure.
}
\details{
To visualize the trajectory graph, a proper graph layout has
to be computed. Ideally, edges should not cross and nodes should not
overlap (i.e., a planar embedding of the graph). CellTrails enables the
export and import of the trajectory
graph structure using the graphml file format. This file format can be
interpreted by most third-party graph analysis applications,
allowing the user to subject the trajectory graph to a wide range of (tree)
layout algorithms. In particular, its format has additional ygraph
attributes best suited to be used with the Graph Visualization Software
'yEd' which is freely available from yWorks GmbH
(http://www.yworks.com/products/yed) for all major platforms.
\cr\cr
The colors of the nodes can be defined by the parameters
\code{color_by} and \code{name}.
Please note that the trajectory landmarks are indicated by setting
\code{color_by='phenoName'} and {name='landmark'}. States can be indicated
by \code{color_by='phenoName'} and {name='state'}.
\cr\cr
If a layout is already present in the provided \code{CellTrailsSet}
object, the samples' coordinates will be listed in the graphml file.
\cr \cr
\emph{Diagnostic messages}
\cr \cr
An error is thrown if the trajectory has not been computed yet; function
\code{fitTrajectory} needs to be called first. Feature names and phenotype
names get checked and will throw an error if not contained in the dataset.
Please note, the parameter \code{name} is case-sensitive.
}
\examples{
# Example data
data(exSCE)

\dontrun{
# Export trajectory graph structure to graphml
# Color nodes by gene expression (e.g, feature_10)
write.ygraphml(sce, file="yourFilePath", color_by="featureName",
              name="feature_10")

# Color nodes by metadata (e.g., state) and
# label nodes by the (simulated) age of each sample
write.ygraphml(sce, file="yourFilePath", color_by="phenoName",
              name="state", node_label="age")

# Color and label nodes by landmark type and id
write.ygraphml(sce, file="yourFilePath", color_by="phenoName",
              name="landmark", node_label="landmark")}
}
\seealso{
\code{fitTrajectory} \code{featureNames} \code{phenoNames}
}
\author{
Daniel C. Ellwanger
}
