% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{states<-}
\alias{states<-}
\alias{states<-,SingleCellExperiment-method}
\title{SET states}
\usage{
states(object) <- value
}
\arguments{
\item{object}{An object of class \code{SingleCellExperiment}}

\item{value}{A numeric, character or factor vector}
}
\value{
An updated object of class \code{SingleCellExperiment}
}
\description{
Sets states to a \code{SingleCellExperiment} object
}
\details{
State information is added to a
\code{SingleCellExperiment} object via \code{colData}. If the
vector containing the cluster assignments is numeric, the prefix
"S" is added and the vector is converted to type factor.
}
\examples{
# Example data
data(exSCE)

# Assign clusters
cl <- kmeans(logcounts(exSCE), centers=10)$cluster
states(exSCE) <- cl
}
\seealso{
colData
}
\author{
Daniel C. Ellwanger
}
