% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{plotStateExpression}
\alias{plotStateExpression}
\alias{plotStateExpression,SingleCellExperiment-method}
\title{Visualize feature expression distribution per state}
\usage{
plotStateExpression(sce, feature_name)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{feature_name}{The name of the feature to be visualized}
}
\value{
A \code{ggplot} object
}
\description{
Violin plots showing the expression distribution of a feature per state.
}
\details{
Each data point displays the feature’s expression value in a
single sample. A violine plot shows the density (mirrored on the y-axis) of
the expression distribution per sample.
}
\examples{
# Example data
data(exSCE)

plotStateExpression(exSCE, feature_name="feature_1")
}
\seealso{
\code{ggplot} \code{states}
}
\author{
Daniel C. Ellwanger
}
