% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsHelper.R
\name{.smoothCms}
\alias{.smoothCms}
\title{.smoothCms}
\usage{
.smoothCms(knn, cms_raw, cell_names, k_min, k)
}
\arguments{
\item{knn}{List with three elements. First "index" with indices of knn cells.
Second "distance" with distances to knn cells. Third a slot named by
\code{group} variable with group level of knn cells.}

\item{cms_raw}{Matrix with raw cms scores for all cells specified in
\code{cell_names} and \code{knn}. Colnames need to be "cms.}

\item{cell_names}{Character vector with cell names corresponding to the
rownames of the list elements in \code{knn} and \code{rownames(cms_raw)}.}

\item{k_min}{Numeric. Minimum number of knn to include.
Default is NA (see Details).}

\item{k}{Numeric. Number of k-nearest neighbours (knn) to use.}
}
\value{
matrix with two columns ("cms_smooth", "cms").
}
\description{
Performs weighted smoothening of cms scores
}
\details{
Internal function to smooth cms scores. In a complete random setting
 cms scores are uniform distributed. To reduce the resulting random variance
 and enable visualization of local pattern cms scores can be smoothened
 assuming that within one region mixing is uniform. Generates smoothened cms
 scores using weigthed means of cms scores within the k-nearest
 neighbourhood. Reciprocal distances are used as weights.
}
\seealso{
\code{\link{.cmsCell}}, \code{\link{cms}}

Other helper functions: 
\code{\link{.cmsCell}()},
\code{\link{.defineSubspace}()},
\code{\link{.filterKnn}()},
\code{\link{.filterLocMin}()},
\code{\link{.ldfKnn}()}
}
\concept{helper functions}
