% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_pipeline_list}
\alias{as_pipeline_list}
\title{convert benchmark_tbl to list}
\usage{
as_pipeline_list(x)
}
\arguments{
\item{x}{the benchmark_tbl object to convert}
}
\value{
list containing the results with names set to data and pipeline steps
  separated by ..
}
\description{
convert a benchmark_tbl to a list where the name of the elements represent the pipeline steps separated by "..". This can be useful for using the apply family of functions.
}
\examples{
# list of data
datasets <- list(
    set1 = rnorm(500, mean = 2, sd = 1),
    set2 = rnorm(500, mean = 1, sd = 2)
)

# list of functions
add_noise <- list(
    none = identity,
    add_bias = function(x) { x + 1 }
)

res <- apply_methods(datasets, add_noise)
as_pipeline_list(res)
}
\seealso{
\code{\link{collapse_pipeline}}
}
