% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_data_preprocessing.R
\name{cleanData}
\alias{cleanData}
\title{Clean data (remove 0s and NAs, remove concentration levels with insufficient
number of replicates)}
\usage{
cleanData(rawData, minReplicates = 3)
}
\arguments{
\item{rawData}{\strong{data.frame} \cr data set to be cleaned, result of
\code{\link{readDataTable}} or \code{\link{readDataSE}}.}

\item{minReplicates}{\strong{integer(1)} \cr Minimal number of replicates
per concentration level. Concentration levels with too few data points will
be removed.}
}
\value{
list of data.frames, each element contains data for a specific
concentration level
}
\description{
Clean data (remove 0s and NAs, remove concentration levels with insufficient
number of replicates)
}
\examples{
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
    package = "CalibraCurve"
)
D_list <- readDataSE(file,
    concColName = "amount_fmol",
    substColName = "Substance", assayNumber = 1
)
cleanData(D_list[[1]])
}
