% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testis_expression.R
\name{testis_expression}
\alias{testis_expression}
\title{Gene expression in testis cells}
\usage{
testis_expression(
  cells = c("all", "germ_cells", "somatic_cells", "SSC", "Spermatogonia",
    "Early_spermatocyte", "Late_spermatocyte", "Round_spermatid", "Elongated_spermatid",
    "Sperm1", "Sperm2", "Macrophage", "Endothelial", "Myoid", "Sertoli", "Leydig"),
  genes = NULL,
  include_CTP = FALSE,
  scale_lims = NULL,
  values_only = FALSE
)
}
\arguments{
\item{cells}{\code{character} defining the testis cell types to be plotted.
Can be "germ_cells", "somatic_cells", "all" (default), or any or a
combination of "SSC", "Spermatogonia", "Early_spermatocyte",
"Late_spermatocyte", "Round_spermatid", "Elongated_spermatid", "Sperm1",
"Sperm2", "Macrophage", "Endothelial", "Myoid", "Sertoli", "Leydig".}

\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{scale_lims}{\verb{vector of length 2} setting the lower and upper limits
of the heatmap colorbar. By default, the lower limit is 0, and the upper
limit corresponds to the third quartile of the logcounts values.}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
SingleCellExperiment instead of the heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected CT genes expression in single cells from adult
testis. If \code{values_only = TRUE}, a SingleCellExperiment is returned
instead.
}
\description{
Plots a heatmap of genes expression in the different types of testis cells,
using scRNAseq data from "The adult human testis transcriptional cell atlas"
(Guo et al. 2018)
}
\examples{
\dontrun{
testis_expression(cells = "germ_cells",
                  genes = c("MAGEA1", "MAGEA3", "MAGEA4"))
}
}
