% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterOffTarget.R
\name{filterOffTarget}
\alias{filterOffTarget}
\title{filter off-targets and generate reports.}
\usage{
filterOffTarget(
  scores = NULL,
  min.score = 0.01,
  topN = 200,
  topN.OfftargetTotalScore = 10,
  annotateExon = TRUE,
  txdb = NULL,
  orgAnn = NULL,
  ignore.strand = TRUE,
  outputDir = NULL,
  oneFilePergRNA = FALSE,
  fetchSequence = TRUE,
  upstream = 200,
  downstream = 200,
  BSgenomeName = NULL,
  genomeSeqFile = NULL,
  baseBeforegRNA = 4,
  baseAfterPAM = 3,
  gRNA.size = 20,
  PAM.location = "3prime",
  PAM.size = 3,
  featureWeightMatrixFile = featureWeightMatrixFile_default(),
  rule.set = c("Root_RuleSet1_2014", "Root_RuleSet2_2016", "CRISPRscan", "DeepCpf1"),
  chrom_acc = NULL,
  calculategRNAefficacyForOfftargets = TRUE
)
}
\arguments{
\item{scores}{a data frame output from getOfftargetScore. It contains}

\item{min.score}{minimum score of an off target to included in the final
output, default 0.5}

\item{topN}{top N off targets to be included in the final output, default
100}

\item{topN.OfftargetTotalScore}{top N off target used to calculate the total
off target score, default 10}

\item{annotateExon}{Choose whether or not to indicate whether the off target
is inside an exon or not, default TRUE}

\item{txdb}{TxDb object, for creating and using TxDb object, please refer to
GenomicFeatures package. For a list of existing TxDb object, please search
for annotation package starting with Txdb at
http://www.bioconductor.org/packages/release/BiocViews.html#___AnnotationData,
such as TxDb.Rnorvegicus.UCSC.rn5.refGene for rat,
TxDb.Mmusculus.UCSC.mm10.knownGene for mouse,
TxDb.Hsapiens.UCSC.hg19.knownGene for human,
TxDb.Dmelanogaster.UCSC.dm3.ensGene for Drosophila and
TxDb.Celegans.UCSC.ce6.ensGene for C.elegans}

\item{orgAnn}{organism annotation mapping such as org.Hs.egSYMBOL in
org.Hs.eg.db package for human}

\item{ignore.strand}{default to TRUE}

\item{outputDir}{the directory where the off target analysis and reports
will be written to}

\item{oneFilePergRNA}{write to one file for each gRNA or not, default to
FALSE}

\item{fetchSequence}{Fetch flank sequence of off target or not, default TRUE}

\item{upstream}{upstream offset from the off target start, default 200}

\item{downstream}{downstream offset from the off target end, default 200}

\item{BSgenomeName}{BSgenome object. Please refer to available.genomes in
BSgenome package. For example,
\itemize{
 \item BSgenome.Hsapiens.UCSC.hg19 - for hg19
 \item BSgenome.Mmusculus.UCSC.mm10 - for mm10
 \item BSgenome.Celegans.UCSC.ce6 - for ce6
 \item BSgenome.Rnorvegicus.UCSC.rn5 - for rn5
 \item BSgenome.Dmelanogaster.UCSC.dm3 - for dm3
}}

\item{genomeSeqFile}{Other than BSgenomeName, a custome FASTA file can be 
supplied, if set, overwrites BSgenomeName.}

\item{baseBeforegRNA}{Number of bases before gRNA used for calculating gRNA
efficiency, default 4}

\item{baseAfterPAM}{Number of bases after PAM used for calculating gRNA
efficiency, default 3}

\item{gRNA.size}{The size of the gRNA, default 20 for spCas9}

\item{PAM.location}{PAM location relative to gRNA. For example, spCas9 PAM
is located on the 3 prime while cpf1 PAM is located on the 5 prime}

\item{PAM.size}{PAM length, default 3 for spCas9}

\item{featureWeightMatrixFile}{Feature weight matrix file used for
calculating gRNA efficiency. By default DoenchNBT2014 weight matrix is used.
To use alternative weight matrix file, please input a csv file with first
column containing significant features and the second column containing the
corresponding weights for the features. Please see Doench et al., 2014 for
details.}

\item{rule.set}{Specify a rule set scoring system for calculating gRNA
efficacy.}

\item{chrom_acc}{Optional binary variable indicating chromatin accessibility
information with 1 indicating accessible and 0 not accessible.}

\item{calculategRNAefficacyForOfftargets}{Default to TRUE to output gRNA
efficacy for offtargets as well as ontargets. Set it to FALSE if only need
gRNA efficacy calculated for ontargets only to speed up the analysis. Please
refer to https://support.bioconductor.org/p/133538/#133661 for potential use
cases of offtarget efficacies.}
}
\value{
A data frame with details of off-targets for the given gRNA.
\itemize{
 \item strand - strand of the off-target, + for plus and - for minus strand
 \item chrom - chromosome of the off-target
 \item chromStart - start position of the off-target
 \item chromEnd - end position of the off-target
 \item name - gRNA name
 \item gRNAPlusPAM - gRNA sequence with PAM sequence concatenated
 \item OffTargetSequence - the genomic sequence of the off-target
 \item n.mismatch - number of mismatches between the off-target and the gRNA
 \item forViewInUCSC - string for viewing in UCSC genome browser, e.g., 
 chr14:31665685-31665707
 \item score - score of the off-target
 \item mismatch.distance2PAM - comma-separated distances of all mismatches to 
 PAM, e.g., 14,11 means one mismatch is 14 bp away from PAM and the other 
 mismatch is 11 bp away from PAM
 \item alignment - alignment between gRNA and off-target, 
 e.g., ......G..C.......... means that this off-target aligns with gRNA 
 except that G and C are mismatches
 \item NGG - whether this off-target contains canonical PAM (1 for yes, 
 0 for no)
 \item mean.neighbor.distance.mismatch - mean distance between neighboring 
 mismatches
}

\itemize{
 \item offtargets - a data frame with off-target analysis results
 \item summary - a data frame with summary of the off-target analysis results
}
}
\description{
filter off-targets that meet the criteria set by users such as minimum score, 
topN. In addition, off target was annotated with flank sequence, gRNA 
cleavage efficiency and whether it is inside an exon or not if fetchSequence
is set to TRUE and annotateExon is set to TRUE
}
\examples{

library(CRISPRseek)
library(BSgenome.Hsapiens.UCSC.hg19)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)

hitsFile <-  system.file("extdata", "hits.txt", package = "CRISPRseek")
hits <- read.table(hitsFile, sep = "\t", 
                   header = TRUE, 
                   stringsAsFactors = FALSE)
featureVectors <- buildFeatureVectorForScoring(hits)
scores <- getOfftargetScore(featureVectors)

outputDir <- tempdir()
results <- filterOffTarget(scores, 
                           BSgenomeName = Hsapiens, 
                           txdb = TxDb.Hsapiens.UCSC.hg19.knownGene,
                           orgAnn = org.Hs.egSYMBOL, 
                           outputDir = outputDir,
                           min.score = 0.1, 
                           topN = 10, 
                           topN.OfftargetTotalScore = 5)
results$offtargets
results$summary

}
\references{
Doench JG, Hartenian E, Graham DB, Tothova Z, Hegde M, Smith I,
Sullender M, Ebert BL, Xavier RJ, Root DE. Rational design of highly active
sgRNAs for CRISPR-Cas9-mediated gene inactivation. Nat Biotechnol. 2014 Sep
3. doi: 10.1038 nbt.3026 Lihua Julie Zhu, Benjamin R. Holmes, Neil Aronin
and Michael Brodsky. CRISPRseek: a Bioconductor package to identify
target-specific guide RNAs for CRISPR-Cas9 genome-editing systems. Plos One
Sept 23rd 2014
}
\seealso{
offTargetAnalysis
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
