% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_beta_r2}
\alias{plot_beta_r2}
\alias{plot_beta_r2,CEMiTool-method}
\title{Soft-threshold beta selection graph}
\usage{
plot_beta_r2(cem, ...)

\S4method{plot_beta_r2}{CEMiTool}(cem, plot_title = "Scale independence (beta selection)")
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{plot_title}{title of the graph}
}
\value{
Object of class \code{CEMiTool} with beta x R squared plot
}
\description{
Creates a graph showing each possible soft-threshold value and its corresponding R squared value
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot scale-free model fit as a function of the soft-thresholding beta parameter choice
cem <- plot_beta_r2(cem)
# Check resulting plot
show_plot(cem, "beta_r2")

}
