% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cemitool.R
\name{mod_gene_num}
\alias{mod_gene_num}
\alias{mod_gene_num,CEMiTool-method}
\title{Get the number of genes in modules in a CEMiTool object}
\usage{
mod_gene_num(cem, module = NULL)

\S4method{mod_gene_num}{CEMiTool}(cem, module = NULL)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}}

\item{module}{Default is NULL. If a character string designating a module is
given, the number of genes in that module is returned instead.}
}
\value{
The number of genes in module(s)
}
\description{
Get the number of genes in modules in a CEMiTool object
}
\examples{
# Get example CEMiTool object
data(cem)
# Get the number of genes in modules
mod_gene_num(cem)
# Get the number of genes in module M1
mod_gene_num(cem, "M1")

}
