% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{generate_report}
\alias{generate_report}
\alias{generate_report,CEMiTool-method}
\title{CEMiTool report}
\usage{
generate_report(cem, ...)

\S4method{generate_report}{CEMiTool}(
  cem,
  max_rows_ora = 50,
  title = "Report",
  directory = "./Reports/Report",
  force = FALSE,
  ...
)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{parameters to rmarkdown::render}

\item{max_rows_ora}{maximum number of rows in Over Representation Analysis table results}

\item{title}{Character string with the title of the report.}

\item{directory}{Directory name for results.}

\item{force}{If the directory exists, execution will not stop.}
}
\value{
An HTML file with an interactive report of CEMiTool analyses.
}
\description{
Creates report for CEMiTool results
}
\examples{
\dontrun{  
# Get example CEMiTool object
data(cem)
generate_report(cem, output_format=c("pdf_document", "html_document"))
}

}
