% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportMethods.R
\name{importPublicData}
\alias{importPublicData}
\alias{importPublicData,character,character,ANY,character-method}
\title{importPublicData}
\usage{
importPublicData(
  origin = c("FANTOM5", "FANTOM3and4", "ENCODE", "ZebrafishDevelopment"),
  dataset,
  group,
  sample
)

\S4method{importPublicData}{character,character,ANY,character}(
  origin = c("FANTOM5", "FANTOM3and4", "ENCODE", "ZebrafishDevelopment"),
  dataset,
  group,
  sample
)
}
\arguments{
\item{origin}{Character vector specifying one of the available resources for
CAGE data (\code{"FANTOM5"}, \code{"FANTOM3and4"}, \code{"ENCODE"} or \code{"ZebrafishDevelopment"}).}

\item{dataset}{Character vector specifying one or more of the datasets
available in the selected resource. For FANTOM5 it can be either
\code{"human"} or  \code{"mouse"}, and only one of them can be specified at a
time. For other resources please refer to the vignette of the
corresponding data package for the list of available datasets.
Multiple datasets mapped to the same genome can be specified to
combine selected samples from each.}

\item{group}{Character string specifying one or more groups within specified
dataset(s), from which the samples should be selected.  The \code{group}
argument is used only when importing TSSs from data packages and
ignored for "FANTOM5".  For available groups in each dataset please
refer to the vignette of the corresponding data package. Either only
one group has to be specified (if all selected samples belong to the
same group) or one group per sample (if samples belong to different
groups).  In the latter case, the number of elements in \code{group} must
match the number of elements in \code{sample}.}

\item{sample}{Character string specifying one or more CAGE samples.  Check
the corresponding data package for available samples within each group
and their labels. For FANTOM5 resource, list of all human (~1000) and
mouse (~) samples can be obtained in \emph{CAGEr} by loading
\code{data(FANTOM5humanSamples)} and \code{data(FANTOM5mouseSamples)},
respectively.  Use the names from the \code{sample} column to specify
which samples should be imported.}
}
\value{
A \code{\link{CAGEexp}} object is returned, containing information on library
size, CTSS coordinates and tag count matrix.  The object is ready for \emph{CAGEr}
analysis (normalisation, tag clustering, …).
}
\description{
Imports CAGE data from different sources into a \code{\link{CAGEexp}} object.  After
the object has been created the data can be further manipulated and
visualized using other functions available in the \emph{CAGEr} package and
integrated with other analyses in R.  Available resources include:
}
\details{
\itemize{
\item FANTOM5 datasets (Forrest \emph{et al.,} Nature 2014) for numerous human and
mouse samples (primary cells, cell lines and tissues), which are fetched
directly from FANTOM5 online resource at
\href{https://fantom.gsc.riken.jp/5/data}{https://fantom.gsc.riken.jp/5/data}.
\item FANTOM3 and 4 datasets (Carninci _et al., _ Science 2005, Faulkner
\emph{et al.,} Nature Genetics 2009, Suzuki \emph{et al.} Nature Genetics 2009) from
\emph{FANTOM3and4CAGE} data package available from Bioconductor.
\item ENCODE datasets (Djebali \emph{et al.} Nature 2012) for numerous human cell
lines from \emph{ENCODEprojectCAGE} data package, which is available for
download from \href{http://promshift.genereg.net/CAGEr/}{http://promshift.genereg.net/CAGEr/}.
\item Zebrafish (\emph{Danio rerio}) developmental timecourse datasets (Nepal \emph{et al.} Genome
Research 2013) from \emph{ZebrafishDevelopmentalCAGE} data package, which
is available for download from
\href{http://promshift.genereg.net/CAGEr/}{http://promshift.genereg.net/CAGEr/}.
}
}
\examples{
\dontrun{
### importing FANTOM5 data

# list of FANTOM5 human tissue samples

data(FANTOM5humanSamples)
head(subset(FANTOM5humanSamples, type == "tissue"))

# import selected samples
f5 <- importPublicData(
  origin="FANTOM5", dataset = "human",
  sample = c("adipose_tissue__adult__pool1", "adrenal_gland__adult__pool1",
             "aorta__adult__pool1"))

CTSScoordinatesGR(f5)

### importing FANTOM3/4 data from a data package

library(FANTOM3and4CAGE)

# list of mouse datasets available in this package

data(FANTOMmouseSamples)
unique(FANTOMmouseSamples$dataset)
head(subset(FANTOMmouseSamples, dataset == "FANTOMtissueCAGEmouse"))
head(subset(FANTOMmouseSamples, dataset == "FANTOMtimecourseCAGEmouse"))

# import selected samples from two different mouse datasets

f34 <- importPublicData(
  origin="FANTOM3and4", dataset = c("FANTOMtissueCAGEmouse", "FANTOMtimecourseCAGEmouse"),
  group = c("brain", "adipogenic_induction"),
  sample = c("CCL-131_Neuro-2a_treatment_for_6hr_with_MPP+", "DFAT-D1_preadipocytes_2days"))

f34 <- importPublicData(
  origin="FANTOM3and4", dataset = c("FANTOMtissueCAGEmouse"),
  group = c("brain"),
  sample = c("CCL-131_Neuro-2a_treatment_for_6hr_with_MPP+"))

CTSScoordinatesGR(f34)

}

}
\references{
\itemize{
\item Carninci \emph{et al.,} (2005). \emph{The Transcriptional Landscape of the Mammalian
Genome}. Science \strong{309}(5740):1559-1563.
\item Djebali \emph{et al.,} (2012). \emph{Landscape of transcription in human cells.}
Nature \strong{488}(7414):101-108.
\item Faulkner \emph{et al.,} (2009). \emph{The regulated retrotransposon transcriptome of
mammalian cells.}, Nature Genetics \strong{41}:563-571.
\item Forrest \emph{et al.,} (2014). \emph{A promoter-level mammalian expression atlas.}
Nature \strong{507}(7493):462-470.
\item Nepal \emph{et al.,} (2013). \emph{Dynamic regulation of the transcription
initiation landscape at single nucleotide resolution during vertebrate
embryogenesis}. Genome Research \strong{23}(11):1938-1950.
\item Suzuki_et al.,_ (2009). The transcriptional network that controls growth
arrest and differentiation in a human myeloid leukemia cell line_. Nature
Genetics \strong{41}:553-562.
}
}
\seealso{
Other FANTOM data: 
\code{\link{FANTOM5humanSamples}},
\code{\link{FANTOM5mouseSamples}}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{FANTOM data}
