% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{consensusClustersTpm}
\alias{consensusClustersTpm}
\alias{consensusClustersTpm,CAGEexp-method}
\title{Extracting consensus clusters tpm matrix from CAGEr object}
\usage{
consensusClustersTpm(object)

\S4method{consensusClustersTpm}{CAGEexp}(object)
}
\arguments{
\item{object}{A CAGEr object.}
}
\value{
Returns the \code{matrix} of normalized expression values of CAGE clusters
across all samples.
}
\description{
Extracts a table with normalized CAGE tag values for consensus
clusters across all samples from a \code{\link{CAGEr}} object.
}
\examples{
head(consensusClustersTpm(exampleCAGEexp))

}
\seealso{
\code{\link{consensusClustersSE}}

Other CAGEr clustering methods: 
\code{\link{distclu}()},
\code{\link{paraclu}()}
}
\author{
Vanja Haberle
}
\concept{CAGEr clustering methods}
