% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregationMethods.R
\name{aggregateTagClusters}
\alias{aggregateTagClusters}
\alias{aggregateTagClusters,CAGEr-method}
\title{Aggregate TCs across all samples}
\usage{
aggregateTagClusters(
  object,
  tpmThreshold = 5,
  excludeSignalBelowThreshold = TRUE,
  qLow = NULL,
  qUp = NULL,
  maxDist = 100,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{aggregateTagClusters}{CAGEr}(
  object,
  tpmThreshold = 5,
  excludeSignalBelowThreshold = TRUE,
  qLow = NULL,
  qUp = NULL,
  maxDist = 100,
  useMulticore = FALSE,
  nrCores = NULL
)
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object}

\item{tpmThreshold}{Ignore tag clusters with normalized signal \verb{< tpmThreshold}
when constructing the consensus clusters.}

\item{excludeSignalBelowThreshold}{When \code{TRUE} the tag clusters with
normalized signal \verb{< tpmThreshold} will not contribute to the total
CAGE signal of a consensus cluster.  When set to \code{FALSE} all TCs that
overlap consensus clusters will contribute to the total signal,
regardless whether they pass the threshold for constructing the
clusters or not.}

\item{qLow, qUp}{Set which "lower" (or "upper") quantile should be used as 5'
(or 3') boundary of the tag cluster.  If \code{NULL} the start (for \code{qLow})
or end (for \code{qUp}) position of the TC is used.}

\item{maxDist}{Maximal length of the gap (in base-pairs) between two tag
clusters for them to be part of the same consensus clusters.}

\item{useMulticore}{Logical, should multicore be used (supported only on
Unix-like platforms).}

\item{nrCores}{Number of cores to use when \code{useMulticore = TRUE}.  Default
(\code{NULL}) uses all detected cores.}
}
\value{
Returns the object in which the \emph{experiment} \code{consensusClusters} will
be occupied by a \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}} containing the cluster
coordinates as row ranges, and their expression levels in the \code{counts} and
\code{normalized} assays.  These genomic ranges are returned by the
\code{\link{consensusClustersGR}} function and the whole object can be accessed with
the \code{\link{consensusClustersSE}} function.  The CTSS ranges of the
\code{tagCountMatrix} \emph{experiment} will gain a \code{cluster} column indicating which
cluster they belong to.  Lastly, the number of CTSS outside clusters will be
documented in the \code{outOfClusters} column data.
}
\description{
Aggregates tag clusters (TCs) across all CAGE datasets within
the CAGEr object to create a referent set of consensus clusters.
}
\details{
Since the tag clusters (TCs) returned by the CTSS clustering functions
function are constructed separately for every CAGE sample within the CAGEr
object, they can differ between samples in both their number, genomic
coordinates, position of dominant TSS and overall signal.  To be able to
compare all samples at the level of clusters of TSSs, TCs from all CAGE
datasets are aggregated into a single set of consensus clusters.  First, TCs
with signal \verb{>= tpmThreshold} from all CAGE datasets are selected, and their
5' and 3' boundaries are determined based on provided \code{qLow} and \code{qUp}
parameter (or the start and end coordinates, if they are set to \code{NULL}).
Finally, the defined set of TCs from all CAGE datasets is reduced to a
non-overlapping set of consensus clusters by merging overlapping TCs and TCs
\verb{<= maxDist} base-pairs apart.  Consensus clusters represent a referent set
of promoters that can be further used for expression profiling or detecting
"shifting" (differentially used) promoters between different CAGE samples.
}
\examples{

consensusClustersGR(exampleCAGEexp)
ce <- aggregateTagClusters( exampleCAGEexp, tpmThreshold = 50
                          , excludeSignalBelowThreshold = FALSE, maxDist = 100)
consensusClustersGR(ce)

ce <- aggregateTagClusters( exampleCAGEexp, tpmThreshold = 50
                          , excludeSignalBelowThreshold = TRUE, maxDist = 100)
consensusClustersGR(ce)

ce <- aggregateTagClusters( exampleCAGEexp, tpmThreshold = 50
                          , excludeSignalBelowThreshold = TRUE, maxDist = 100
                          , qLow = 0.1, qUp = 0.9)
consensusClustersGR(ce)

}
\seealso{
Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{consensusClustersGR}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr clusters functions}
\concept{CAGEr object modifiers}
