% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPrepare.R
\name{findOrthoGenes}
\alias{findOrthoGenes}
\title{Orthologs Gene Names}
\usage{
findOrthoGenes(
  from_organism,
  from_values,
  method = c("gprofiler", "homologene", "babelgene")
)
}
\arguments{
\item{from_organism}{An organism defined as in Ensembl:
drerio, mmusculus, celegans, dmelanogaster, etc. This is the source organism
from which you want to convert the gene names to Homo sapiens.}

\item{from_values}{A vector of gene names from the current species studied.}

\item{method}{Ortholog mapping method.}
}
\value{
Return a data frame with 2 columns containing the gene names
for the two species.
First column is the gene name from the source organism
and the second column corresponds to the  homologous gene name
in  Homo sapiens.
}
\description{
By default, BulkSignalR is designed to work with Homo sapiens.
In order to work with other organisms, gene names need to be first converted
to human following an orthology mapping process.
}
\examples{
data(bodyMap.mouse)

idx <- sample(nrow(bodyMap.mouse), 20)
bodyMap.mouse <- bodyMap.mouse[idx,]

ortholog.dict <- findOrthoGenes(
    from_organism = "mmusculus",
    from_values = rownames(bodyMap.mouse)
)

}
