% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R,
%   R/BSRInferenceComp-class.R
\name{reduceToPathway}
\alias{reduceToPathway}
\alias{reduceToPathway,BSRInference-method}
\alias{reduceToPathway,BSRInferenceComp-method}
\title{Aggregate ligands and receptors at the pathway level}
\usage{
\S4method{reduceToPathway}{BSRInference}(obj)

\S4method{reduceToPathway}{BSRInferenceComp}(obj)
}
\arguments{
\item{obj}{BSRInferenceComp object}
}
\value{
A BSRInference object reduced to only report one row per pathway.
The information of which ligand interacted with which receptor is lost as
all the ligands and all the receptors forming pairs related to a certain
pathway are combined.
For a given pathway, the reported P-values and target genes are those of
the best ligand-receptor pair that
was in this pathway.
Receptors and ligands are combined in two semi-colon-separated
lists surrounded by curly brackets in the tabular slot \code{LRinter},
while the list representation slots (\code{ligands} and
\code{receptors}) are update accordingly.

A BSRInferenceComp object reduced to only report one row per pathway.
The information of which ligand interacted with which receptor is lost as
all the ligands and all the receptors forming pairs related to a certain
pathway are combined.
For a given pathway, the reported P-values and target genes are those of
the best ligand-receptor pair that was in this pathway.
The same logic applies to the LR-score, and the ligand and receptor
expression.
Receptors and ligands are combined in two semi-colon-separated
lists surrounded by curly brackets in the tabular slot \code{LRinter},
while the list representation slots (\code{ligands} and
\code{receptors}) are update accordingly.
}
\description{
Simplifies a ligand-receptor inference object to focus on
the pathways.

Simplifies a ligand-receptor inference object to focus on
the pathways.
}
\examples{
data(bsrinf, package = "BulkSignalR")

bsrinf.redP <- reduceToPathway(bsrinf)
data(bsrinf.comp, package = "BulkSignalR")

bsrinf.redP <- reduceToPathway(bsrinf.comp)
}
