% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{pval_plotter}
\alias{pval_plotter}
\title{P-value Plotter
This function allows you to plot p-values of explained variation}
\usage{
pval_plotter(DE_results)
}
\arguments{
\item{DE_results}{Differential Expression analysis result (a named list of
dataframes corresponding to each analysis completed with a "pvalue" column)}
}
\value{
boxplots of pvalues for each condition
}
\description{
P-value Plotter
This function allows you to plot p-values of explained variation
}
\examples{
library(scran)
se <- mockSCE()
differential_expression <- BatchQC::DE_analyze(se = se,
                                                method = "DESeq2",
                                                batch = "Treatment",
                                                conditions = c(
                                                "Mutation_Status"),
                                                assay_to_analyze = "counts",
                                                padj_method = "BH")
pval_summary(differential_expression)
pval_plotter(differential_expression)

}
