% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{PCA_plotter}
\alias{PCA_plotter}
\title{This function allows you to plot PCA}
\usage{
PCA_plotter(se, nfeature, color, shape, batch, assays, xaxisPC,
yaxisPC, log_option = FALSE)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{nfeature}{number of features}

\item{color}{choose a color}

\item{shape}{choose a shape}

\item{batch}{variable representing batch (for ellipses)}

\item{assays}{array of assay names from \code{se}}

\item{xaxisPC}{the PC to plot as the x axis}

\item{yaxisPC}{the PC to plot as the y axis}

\item{log_option}{TRUE if data should be logged before plotting (recommended
for sequencing counts), FALSE if data should not be logged (for instance,
data is already logged); FALSE by default}
}
\value{
List containing PCA info, PCA variance and PCA plot
}
\description{
This function allows you to plot PCA
}
\examples{
library(scran)
se <- mockSCE()
se_object_ComBat_Seq <- BatchQC::batch_correct(se, method = "ComBat-Seq",
                                            assay_to_normalize = "counts",
                                            batch = "Mutation_Status",
                                            covar = "Treatment",
                                            output_assay_name =
                                                "ComBat_Seq_Corrected")
pca_plot <- BatchQC::PCA_plotter(se = se_object_ComBat_Seq,
                            nfeature = 2, color = "Mutation_Status",
                            shape = "Treatment", batch = "batch",
                            assays = c("counts", "ComBat_Seq_Corrected"),
                            xaxisPC = 1, yaxisPC = 2, log_option = FALSE)
pca_plot$plot
pca_plot$var_explained

}
