% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computation.R
\name{getBanksyMatrix}
\alias{getBanksyMatrix}
\title{Builds the BANKSY matrix from neighborhood matrices.}
\usage{
getBanksyMatrix(
  se,
  M,
  lambda,
  assay_name = NULL,
  scale = FALSE,
  group = NULL,
  verbose = TRUE
)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with \code{computeBanksy} ran.}

\item{M}{A integer scalar specifying the highest azimuthal
Fourier harmonic to compute.}

\item{lambda}{A numeric vector in \eqn{\in [0,1]} specifying a spatial
weighting parameter. Larger values (e.g. 0.8) incorporate more spatial
neighborhood and find spatial domains, while smaller values (e.g. 0.2)
perform spatial cell-typing.}

\item{assay_name}{A string scalar specifying the name of the assay used in
\code{computeBanksy}.}

\item{scale}{A logical scalar specifying whether to scale the features to
zero mean and unit standard deviation. This is performed before
multiplying the assays by their corresponding lambda weighting factors.}

\item{group}{A string scalar specifying a grouping variable for samples in
\code{se}. This is used to scale the samples in each group separately.}

\item{verbose}{A logical scalar specifying verbosity.}
}
\value{
BANKSY matrix.
}
\description{
Builds the BANKSY matrix from neighborhood matrices.
}
\details{
After computation of the neighborhood matrices 
(see \link[Banksy]{computeBanksy}), this function builds the BANKSY matrix by 
concatenating the original expression matrix with the neighborhood matrices,
and scales each matrix by an appropriate weight as determined by 
\code{lambda}. The weights of the own expression matrix, mean neighborhood
 matrix and azimuthal Gabor filter are given by \eqn{\sqrt{1-\lambda}}, 
 \eqn{\sqrt{\lambda/\mu}} and \eqn{\sqrt{\lambda/2\mu}} respectively, where 
 \eqn{\mu=1.5}. In the case where the AGF is not computed, the weights for
 the own and mean neighborhood expression matrix simplify to 
 \eqn{\sqrt{1-\lambda}} and \eqn{\sqrt{\lambda}} respectively.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
banksyMatrix <- getBanksyMatrix(spe, M = 1, lambda = 0.2)

}
