% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{clusterNames}
\alias{clusterNames}
\title{Get names of clustering runs.}
\usage{
clusterNames(se)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with \code{clusterBanksy} ran.}
}
\value{
A character vector of names of clustering runs.
}
\description{
Get names of clustering runs.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
spe <- runBanksyPCA(spe, M = 1, lambda = c(0, 0.2), npcs = 20)
spe <- clusterBanksy(spe, M = 1, lambda = c(0, 0.2), resolution = 1)
clusterNames(spe)

}
