% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BASiCS_PlotDE.R
\name{BASiCS_PlotDE}
\alias{BASiCS_PlotDE}
\alias{BASiCS_PlotDE,BASiCS_ResultsDE-method}
\alias{BASiCS_PlotDE,BASiCS_ResultDE-method}
\alias{BASiCS_PlotDE,missing-method}
\title{Produce plots assessing differential expression results}
\usage{
BASiCS_PlotDE(object, ...)

\S4method{BASiCS_PlotDE}{BASiCS_ResultsDE}(
  object,
  Plots = c("MA", "Volcano", "Grid"),
  Parameters = intersect(c("Mean", "Disp", "ResDisp"), names(object@Results)),
  MuX = TRUE,
  ...
)

\S4method{BASiCS_PlotDE}{BASiCS_ResultDE}(
  object,
  Plots = c("Grid", "MA", "Volcano"),
  Mu = NULL,
  TransLogit = FALSE
)

\S4method{BASiCS_PlotDE}{missing}(
  GroupLabel1,
  GroupLabel2,
  ProbThresholds = seq(0.5, 0.9995, by = 0.00025),
  Epsilon,
  EFDR,
  Table,
  Measure,
  EFDRgrid,
  EFNRgrid,
  ProbThreshold,
  Mu,
  TransLogit = FALSE,
  Plots = c("Grid", "MA", "Volcano")
)
}
\arguments{
\item{object}{A \linkS4class{BASiCS_ResultsDE} or 
\linkS4class{BASiCS_ResultDE} object.}

\item{...}{Passed to methods.}

\item{Plots}{Plots plot to produce? Options: "MA", "Volcano", 
"Grid".}

\item{Parameters}{Character vector specifying the parameter(s) to produce 
plots for,
Available options are "Mean", (mu, mean expression),
"Disp" (delta, overdispersion) and "ResDisp" 
(epsilon, residual overdispersion).}

\item{MuX}{Use Mu (mean expression across both chains) as the X-axis for all
MA plots? Default: TRUE.}

\item{Mu, GroupLabel1, GroupLabel2, ProbThresholds, Epsilon, EFDR, Table, Measure, EFDRgrid, EFNRgrid, ProbThreshold}{Internal arguments.}

\item{TransLogit}{Logical scalar controlling whether a logit transform
is applied to the posterior probability in the y-axis of volcano plots.
As logit(0) and logit(1) are undefined, we clip these values near the range
of the data excluding 0 and 1.}
}
\value{
A plot (possibly several combined using 
\code{\link[cowplot]{plot_grid}}).
}
\description{
Produce plots assessing differential expression results
}
\examples{
data(ChainSC)
data(ChainRNA)

Test <- BASiCS_TestDE(Chain1 = ChainSC, Chain2 = ChainRNA,
                      GroupLabel1 = 'SC', GroupLabel2 = 'P&S',
                      EpsilonM = log2(1.5), EpsilonD = log2(1.5),
                      OffSet = TRUE)
BASiCS_PlotDE(Test)
}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}

Alan O'Callaghan
}
