% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{remove_samples}
\alias{remove_samples}
\title{Remove samples based on expression profiles across variables.}
\usage{
remove_samples(
  sce = NULL,
  min_nReads = NULL,
  max_nReads = NULL,
  min_nGenes = NULL,
  max_nGenes = NULL,
  min_percMT = NULL,
  max_percMT = NULL
)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{min_nReads}{A minimum threshold value of the number of reads.}

\item{max_nReads}{A maximum threshold value of the number of reads.}

\item{min_nGenes}{A minimum threshold value of the number of non-zero
expressed genes.}

\item{max_nGenes}{A maximum threshold value of the number of non-zero
expressed genes.}

\item{min_percMT}{A minimum threshold value of the percent of reads that map
to mitochondrial genes.}

\item{max_percMT}{A maximum threshold value of the percent of reads that map
to mitochondrial genes.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function removes sample data by setting minimum and maximum threshold
  values for the metadata.
}
\examples{
data(pbmc_eg)
pbmc <- add_metadata(sce = pbmc_eg, mitochondria_symbol = "^MT-")
pbmc <- remove_samples(sce = pbmc, min_nReads = 0, max_nReads = 1e+10,
                       min_nGenes = 0, max_nGenes = 1e+10,
                       min_percMT = NULL, max_percMT = NULL)

}
