/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class BufferedLineReader {
    private BufferedReader reader;
    private String peekBuffer = null;
    private int lineno = 0;

    public BufferedLineReader(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public BufferedLineReader(File f) throws IOException {
        this.reader = new BufferedReader(new FileReader(f));
    }

    public BufferedLineReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public String readLine() throws IOException {
        String ret;
        if (this.peekBuffer != null) {
            ret = this.peekBuffer;
            this.peekBuffer = null;
        } else {
            ret = this.reader.readLine();
        }
        if (ret != null) {
            ++this.lineno;
        }
        return ret;
    }

    public String peek() throws IOException {
        if (this.peekBuffer == null) {
            this.peekBuffer = this.readLine();
        }
        return this.peekBuffer;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

