/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.taxatree.ConcretRoot;
import edu.msu.cme.rdp.taxatree.Node;
import edu.msu.cme.rdp.taxatree.TaxonHolder;
import edu.msu.cme.rdp.unifrac.UnifracTaxon;
import edu.msu.cme.rdp.unifrac.UnifracTreeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnifracTree
extends ConcretRoot<UnifracTaxon> {
    private Set<Integer> leaves = new LinkedHashSet<Integer>();

    public UnifracTree() {
        super((Node)new UnifracTaxon(0, "Root", "no rank", 0.0f));
        this.leaves.add(0);
    }

    public UnifracResult computeUnifrac() {
        HashSet<MCSample> samplesSet = new HashSet<MCSample>();
        for (TaxonHolder t : this.taxonMap.values()) {
            if (!this.leaves.contains(((UnifracTaxon)t.getTaxon()).getTaxid())) continue;
            for (MCSample sample : ((UnifracTaxon)t.getTaxon()).getSamples()) {
                samplesSet.add(sample);
            }
        }
        ArrayList<MCSample> samples = new ArrayList<MCSample>(new HashSet(samplesSet));
        float[][] unifracMatrix = new float[samples.size()][samples.size()];
        for (int sample1 = 0; sample1 < samples.size(); ++sample1) {
            unifracMatrix[sample1][sample1] = 0.0f;
            for (int sample2 = sample1 + 1; sample2 < samples.size(); ++sample2) {
                float f = this.computeUnifracMetric((MCSample)samples.get(sample1), (MCSample)samples.get(sample2));
                unifracMatrix[sample2][sample1] = f;
                unifracMatrix[sample1][sample2] = f;
            }
        }
        return new UnifracResult(samples, unifracMatrix);
    }

    public UnifracResult computeUnifracSig(int permutations, boolean weighted) {
        UnifracResult real = weighted ? this.computeWeightedUnifrac() : this.computeUnifrac();
        HashMap allSamplesMap = new HashMap();
        HashMap originalSampleMap = new HashMap();
        HashMap<MCSample, Double> totalsMap = new HashMap<MCSample, Double>();
        for (TaxonHolder t : this.taxonMap.values()) {
            if (!originalSampleMap.containsKey(((UnifracTaxon)t.getTaxon()).getTaxid())) {
                originalSampleMap.put(((UnifracTaxon)t.getTaxon()).getTaxid(), new ArrayList());
            }
            if (this.leaves.contains(((UnifracTaxon)t.getTaxon()).getTaxid())) {
                for (MCSample sample : ((UnifracTaxon)t.getTaxon()).getSamples()) {
                    UnifracTreeBuilder.UnifracSample unifracSample = new UnifracTreeBuilder.UnifracSample();
                    unifracSample.count = ((UnifracTaxon)t.getTaxon()).getCount(sample);
                    unifracSample.sample = sample;
                    if (!allSamplesMap.containsKey(sample)) {
                        allSamplesMap.put(sample, new ArrayList());
                    }
                    if (!totalsMap.containsKey(sample)) {
                        totalsMap.put(sample, 0.0);
                    }
                    ((List)allSamplesMap.get(sample)).add(unifracSample);
                    ((List)originalSampleMap.get(((UnifracTaxon)t.getTaxon()).getTaxid())).add(unifracSample);
                    totalsMap.put(sample, (Double)totalsMap.get(sample) + ((UnifracTaxon)t.getTaxon()).getCount(sample));
                }
                continue;
            }
            ((UnifracTaxon)t.getTaxon()).resetSamples();
        }
        ArrayList<MCSample> samples = new ArrayList<MCSample>(allSamplesMap.keySet());
        float[][] unifracMatrix = new float[samples.size()][samples.size()];
        for (int perm = 0; perm < permutations; ++perm) {
            for (int sample1 = 0; sample1 < samples.size(); ++sample1) {
                unifracMatrix[sample1][sample1] = 0.0f;
                for (int sample2 = sample1 + 1; sample2 < samples.size(); ++sample2) {
                    ArrayList<UnifracTreeBuilder.UnifracSample> samplePool = new ArrayList<UnifracTreeBuilder.UnifracSample>();
                    samplePool.addAll((Collection)allSamplesMap.get(samples.get(sample1)));
                    samplePool.addAll((Collection)allSamplesMap.get(samples.get(sample2)));
                    Collections.shuffle(samplePool);
                    for (int taxid : this.leaves) {
                        UnifracTaxon t = (UnifracTaxon)((TaxonHolder)this.taxonMap.get(taxid)).getTaxon();
                        if (!t.containsSample((MCSample)samples.get(sample1)) && !t.containsSample((MCSample)samples.get(sample2))) continue;
                        t.resetSamples(samplePool);
                    }
                    this.refreshInnerTaxa();
                    float val = weighted ? this.computeUnifracMetricWeighted((MCSample)samples.get(sample1), (MCSample)samples.get(sample2), totalsMap) : this.computeUnifracMetric((MCSample)samples.get(sample1), (MCSample)samples.get(sample2));
                    if (val > real.getUnifracMatrix()[sample1][sample2]) {
                        float[] fArray = unifracMatrix[sample1];
                        int n = sample2;
                        fArray[n] = fArray[n] + 1.0f;
                        float[] fArray2 = unifracMatrix[sample2];
                        int n2 = sample1;
                        fArray2[n2] = fArray2[n2] + 1.0f;
                    }
                    for (int taxid : this.leaves) {
                        ((UnifracTaxon)((TaxonHolder)this.taxonMap.get(taxid)).getTaxon()).resetSamples(new ArrayList<UnifracTreeBuilder.UnifracSample>((Collection)originalSampleMap.get(taxid)));
                    }
                    this.refreshInnerTaxa();
                }
            }
        }
        for (float[] row : unifracMatrix) {
            int index = 0;
            while (index < row.length) {
                int n = index++;
                row[n] = row[n] / (float)permutations;
            }
        }
        return new UnifracResult(samples, unifracMatrix);
    }

    private float computeUnifracMetric(MCSample sample1, MCSample sample2) {
        float unique = 0.0f;
        float combined = 0.0f;
        HashSet<Integer> touched = new HashSet<Integer>();
        for (Integer taxid : this.leaves) {
            TaxonHolder leaf;
            TaxonHolder parent = leaf = this.getChild(taxid);
            while (parent.getParent() != null) {
                UnifracTaxon taxon = (UnifracTaxon)parent.getTaxon();
                if (!touched.contains(((UnifracTaxon)parent.getTaxon()).getTaxid())) {
                    touched.add(taxon.getTaxid());
                    if (((UnifracTaxon)parent.getTaxon()).containsSample(sample1) && taxon.containsSample(sample2)) {
                        combined += taxon.getBl();
                    } else if (taxon.containsSample(sample1) || taxon.containsSample(sample2)) {
                        unique += taxon.getBl();
                    }
                }
                parent = parent.getParent();
            }
        }
        return unique / (unique + combined);
    }

    public UnifracResult computeWeightedUnifrac() {
        HashSet<MCSample> samplesSet = new HashSet<MCSample>();
        HashMap<MCSample, Double> totalsMap = new HashMap<MCSample, Double>();
        for (int i : this.leaves) {
            UnifracTaxon leaf = (UnifracTaxon)this.getChildTaxon(i);
            for (MCSample sample : leaf.getSamples()) {
                if (!totalsMap.containsKey(sample)) {
                    totalsMap.put(sample, 0.0);
                }
                samplesSet.add(sample);
                totalsMap.put(sample, (Double)totalsMap.get(sample) + leaf.getCount(sample));
            }
        }
        ArrayList<MCSample> samples = new ArrayList<MCSample>(new HashSet(samplesSet));
        float[][] unifracMatrix = new float[samples.size()][samples.size()];
        for (int sample1 = 0; sample1 < samples.size(); ++sample1) {
            unifracMatrix[sample1][sample1] = 0.0f;
            for (int sample2 = sample1 + 1; sample2 < samples.size(); ++sample2) {
                float f = this.computeUnifracMetricWeighted((MCSample)samples.get(sample1), (MCSample)samples.get(sample2), totalsMap);
                unifracMatrix[sample2][sample1] = f;
                unifracMatrix[sample1][sample2] = f;
            }
        }
        return new UnifracResult(samples, unifracMatrix);
    }

    private float computeUnifracMetricWeighted(MCSample sample1, MCSample sample2, Map<MCSample, Double> totalsMap) {
        float ret = 0.0f;
        for (TaxonHolder taxonHolder : this.taxonMap.values()) {
            UnifracTaxon taxon = (UnifracTaxon)taxonHolder.getTaxon();
            ret = (float)((double)ret + (double)taxon.getBl() * Math.abs(taxon.getCount(sample1) / totalsMap.get(sample1) - taxon.getCount(sample2) / totalsMap.get(sample2)));
        }
        return ret;
    }

    public void printLeaves() {
        for (Integer taxid : this.leaves) {
            UnifracTaxon leaf = (UnifracTaxon)this.getChildTaxon(taxid);
            System.out.println(leaf.getTaxid() + "\t" + leaf.getName() + "\t" + leaf.getRank() + "\t" + leaf.getSamples());
        }
    }

    public void addChild(UnifracTaxon child, int parentId) {
        if (this.leaves.contains(parentId)) {
            this.leaves.remove(parentId);
        }
        this.leaves.add(child.getTaxid());
        super.addChild((Node)child, parentId);
    }

    public void refreshInnerTaxa() {
        for (TaxonHolder t : this.taxonMap.values()) {
            if (this.leaves.contains(((UnifracTaxon)t.getTaxon()).getTaxid())) continue;
            ((UnifracTaxon)t.getTaxon()).resetSamples();
        }
        for (Integer taxid : this.leaves) {
            TaxonHolder leaf = (TaxonHolder)this.taxonMap.get(taxid);
            for (TaxonHolder parent = leaf.getParent(); parent != null; parent = parent.getParent()) {
                for (MCSample sample : ((UnifracTaxon)leaf.getTaxon()).getSamples()) {
                    ((UnifracTaxon)parent.getTaxon()).addSampleCount(sample, ((UnifracTaxon)leaf.getTaxon()).getCount(sample));
                }
            }
        }
    }

    public void addTaxon(int parent, int taxid, String name, MCSample sample, float bl) {
        TaxonHolder parentHolder = (TaxonHolder)this.taxonMap.get(parent);
        if (parentHolder == null) {
            throw new IllegalArgumentException("Couldn't find parent taxon id=" + parent);
        }
        UnifracTaxon parentTaxon = (UnifracTaxon)parentHolder.getTaxon();
        TaxonHolder holder = (TaxonHolder)this.taxonMap.get(taxid);
        if (holder == null) {
            holder = new TaxonHolder((Node)new UnifracTaxon(taxid, name, "", bl), parentHolder);
            UnifracTaxon t = (UnifracTaxon)holder.getTaxon();
            if (sample != null) {
                t.incCount(sample, 1.0);
            }
            parentHolder.addChild(holder);
            if (this.leaves.contains(parentTaxon.getTaxid())) {
                this.leaves.remove(parentTaxon.getTaxid());
            }
            this.leaves.add(t.getTaxid());
            this.taxonMap.put(t.getTaxid(), holder);
        }
    }

    public static class UnifracResult {
        private List<MCSample> samples;
        private float[][] unifracMatrix;

        public UnifracResult(List<MCSample> samples, float[][] unifracMatrix) {
            this.samples = samples;
            this.unifracMatrix = unifracMatrix;
        }

        public List<MCSample> getSamples() {
            return this.samples;
        }

        public float[][] getUnifracMatrix() {
            return this.unifracMatrix;
        }
    }
}

