% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_rtable2measures.R
\name{rtable2measures}
\alias{rtable2measures}
\title{Calculates emasures from result tables}
\usage{
rtable2measures(
  htfile,
  realprediction,
  aucfile = NULL,
  experiment = NULL,
  logFC_threshold = 1,
  pval_threshold = 0.01
)
}
\arguments{
\item{htfile}{hunter table file}

\item{realprediction}{real predictions file}

\item{aucfile}{output AUC plot file}

\item{experiment}{experiment info file to be loaded}

\item{logFC_threshold}{logFC threshold}

\item{pval_threshold}{p-value threshold}
}
\value{
metrics table
}
\description{
Calculates emasures from result tables
}
\examples{
htfile <- system.file("extData", 
"hunter_results_table.txt", package = "ExpHunterSuite")
realprediction <- system.file("extData", 
"ground_truth_DE.txt", package = "ExpHunterSuite")
rtable2measures(htfile, realprediction)
}
\keyword{metrics}
