% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_analysis_library.R
\name{multienricher_topGO}
\alias{multienricher_topGO}
\title{Perform topGO enrichment analysis of a list of genes}
\usage{
multienricher_topGO(
  all_funsys,
  genes_list,
  universe = NULL,
  organism_info,
  gene_id = "entrez",
  algorithm = "classic",
  statistic = "fisher",
  nodeSize = 5,
  task_size = 1,
  workers = 1
)
}
\arguments{
\item{all_funsys}{vector of funsys to use (e.g. MF, Reatcome)}

\item{genes_list}{vector of genes or list of vectors, to be enriched}

\item{universe}{background of genes to use as universe}

\item{organism_info}{from the annotation table: infor on db names etc}

\item{gene_id}{what identifier do the genes use - must be entrez for}

\item{algorithm}{alrgorithm for decting enriched functions - see topGO docs}

\item{statistic}{method for detecting enriched functions}

\item{nodeSize}{related to the creation of the GOdata object}

\item{task_size}{for parallelization}

\item{workers}{for parallelization}
}
\description{
Perform topGO enrichment analysis of a list of genes
}
