% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq2quan.R
\name{fastq2quan}
\alias{fastq2quan}
\title{Produce the quantifications of gene expression based on the fastq files.}
\usage{
fastq2quan(
  threads = 4,
  dir = getwd(),
  pair,
  taxa,
  novel_transcript = FALSE,
  scRNA = FALSE,
  protocol = NULL
)
}
\arguments{
\item{threads}{the number of threads to be used. Default is 4.}

\item{dir}{the working directory. Default is the current working directory.}

\item{pair}{'single' for single-end (SE) reads or 'paired' for paired-end (PE) reads.}

\item{taxa}{the scientific or common name of the organism.}

\item{novel_transcript}{logic, whether identifying novel transcripts is expected or not. Default is FALSE.}

\item{scRNA}{logic, whether single-cell RNA-seq is quantified or not. Default is FALSE.}

\item{protocol}{the single-cell RNA sequencing protocol: dropseq, chromium, or chromiumV3.}
}
\value{
None
}
\description{
Produce the quantifications of gene expression based on the fastq files with alignment-based and alignment-free workflows.
}
\examples{

sra_download(accession = 'SRR11427582')
sra2fastq()
fastq2quan(pair = 'single', taxa = 'Drosophila melanogaster')
}
