\name{taurefList}
\alias{taurefList}
\title{Lookup Table for Computing Tau Scores} 
\description{
This dataset is generated by searching all signatures in the LINCS database
against itself to obtain a background distribution of NCS values (Qref). The
latter is used to compute the Tau scores of the \code{gess_lincs} method in the
\code{signatureSearch} package. The Tau score compares the observed enrichment
score to all others in Qref. It represents the percentage of reference queries
with a lower |NCS| than |NCSq,r|, adjusted to retain the sign of NCSq,r.
NCSq,r is the normalized connectivity score for signature r relative to query
q. A tau of 90 indicates that only 10 percent of reference perturbations showed
stronger connectivity to the query. 
}

\references{
For a detailed description of the \code{gess_lincs} method and its scores, 
please refer to the vignette of the \code{signatureSearch} package by
running \code{browseVignettes("signatureSearch")}.

Subramanian, A., Narayan, R., Corsello, S. M., Peck, D. D., 
Natoli, T. E., Lu, X., Golub, T. R. (2017). A Next Generation 
Connectivity Map: L1000 Platform and the First 1,000,000 Profiles. Cell, 
171(6), 1437-1452.e17. https://doi.org/10.1016/j.cell.2017.10.049
}

\seealso{
    \code{gess_lincs}
}

\examples{
library(ExperimentHub)
eh <- ExperimentHub()
taurefList <- eh["EH3233"]
# taurefList <- eh[["EH3233"]]
}

\keyword{datasets}

