% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanExpr.R
\name{meanExpr}
\alias{meanExpr}
\title{Calculate Mean Value for Replicated Samples}
\usage{
meanExpr(expr_df, cmap_inst)
}
\arguments{
\item{expr_df}{\code{data.frame} containing normalized expression values}

\item{cmap_inst}{\code{data.frame} defining experimental conditions}
}
\value{
\code{data.frame} with mean expression values of replicates
}
\description{
Function averages the normalized gene expression values for different
concentrations, treatment times and replicates of compounds and cell types.
For more context on this step, please consult the corresponding section in the
vignette of this package.
}
\examples{
path <- system.file("extdata", "cmap_instances_02.txt", package="signatureSearchData")
cmap_inst <- read.delim(path, check.names=FALSE) 
expr_df <- as.data.frame(matrix(runif(30), ncol=5))
colnames(expr_df) <- paste0(cmap_inst$perturbation_scan_id[seq_len(5)],".CEL")
mexpr <- meanExpr(expr_df, cmap_inst[seq_len(5),])
}
