% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineResults.R
\name{combineResults}
\alias{combineResults}
\title{Combine Batch-processed Normalization Results}
\usage{
combineResults(chiptype_dir, rerun = TRUE)
}
\arguments{
\item{chiptype_dir}{character vector containing paths to chiptype directories}

\item{rerun}{TRUE or FALSE, whether to run the function}
}
\value{
File storing normalization values for each CEL file type
}
\description{
Function combines batch-processed normalization results from same chip type
into a single data frame. Typically, the input for this step is generated by
the upstream \code{normalizeCel} function. For more context, please consult
the vignette of this package.
}
\examples{
# chiptype_dir <- unique(readRDS("./data/chiptype.rds"))
combineResults(chiptype_dir, rerun=FALSE)
}
