meta <- data.frame(
  Title = c("cmap", "cmap_expr", "cmap_rank",
            "lincs", "lincs_expr",
            "dtlink_db_clue_sti",
            "goAnno", "goAnno_drug", 
            "GO_DATA", "GO_DATA_drug", 
            "taurefList", "ES_NULL",
            "lincs2"),
  Description = c("CMAP log2FC matrix stored in h5 file",
                  "CMAP expression matrix stored in h5 file",
                  "CMAP rank matrix stored in h5 file",
                  "LINCS mod-z scores matrix stored in h5 file",
                  "LINCS expression matrix stored in h5 file",
                  "SQLite database containing drug-target links in drugbank, LINCS and STITCH databases",
                  "GO terms to gene symbols annotation",
                  "GO to drugs annotation after drug to gene/target mapping",
                  "GO annotation environment",
                  "GO annotation environment after drug mappings",
                  "Reference list for computing tau scores of gess_lincs method",
                  "Null distribution of Enrichment Score for computing nominal P-values",
                  "LINCS beta 2020 level 5 mod-z score matrix stored in h5 file"
                  ),
  BiocVersion = c(rep("3.9", 12), "3.14"),
  Genome = rep("GRCh38", 13),
  SourceType = c("CEL", "CEL", "TXT",
                 "HDF5", "HDF5",
                 "CSV",
                 "MySQL", "MySQL",
                 "MySQL", "MySQL", 
                 "RData", "RData",
                 "HDF5"),
  SourceUrl = c("https://portals.broadinstitute.org/cmap/cel_file_chunks.jsp",
                "https://portals.broadinstitute.org/cmap/cel_file_chunks.jsp",
                "ftp://ftp.broad.mit.edu/pub/cmap/rankMatrix.txt.zip",
                "https://www.ncbi.nlm.nih.gov/geo/download/?acc=GSE92742&format=file&file=GSE92742%5FBroad%5FLINCS%5FLevel5%5FCOMPZ%2EMODZ%5Fn473647x12328%2Egctx%2Egz",
                "https://www.ncbi.nlm.nih.gov/geo/download/?acc=GSE92742&format=file&file=GSE92742%5FBroad%5FLINCS%5FLevel3%5FINF%5Fmlr12k%5Fn1319138x12328%2Egctx%2Egz",
                "https://www.drugbank.ca/, https://clue.io/, http://stitch.embl.de/",
                "https://bioconductor.org/packages/release/data/annotation/html/GO.db.html",
                "https://bioconductor.org/packages/release/data/annotation/html/GO.db.html",
                "https://bioconductor.org/packages/release/data/annotation/html/GO.db.html",
                "https://bioconductor.org/packages/release/data/annotation/html/GO.db.html",
                "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE92742",
                "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE92742",
                "https://s3.amazonaws.com/macchiato.clue.io/builds/LINCS2020/level5/level5_beta_trt_cp_n720216x12328.gctx"
                ),
  SourceVersion = c("build02", "build02", "build02",
                    "Mar 03 2017", "Mar 03 2017",
                    "5.0.10; 1.1.1.2; v5.0",
                    "3.7.0",
                    "3.7.0",
                    "3.7.0",
                    "3.7.0",
                    "Mar 03 2017",
                    "Mar 03 2017",
                    "beta"),
  Species = rep("Homo sapiens", 13),
  TaxonomyId = rep(9606, 13),
  Coordinate_1_based = rep(TRUE, 13),
  DataProvider = c("Broad Institute", "Broad Institute", "Broad Institute",
                   "Broad Institute", "Broad Institute",
                   "DrugBank, Broad Institute, STITCH",
                   "GO", "GO", "GO", "GO", 
                   "Broad Institute", "Broad Institute",
                   "Broad Institute"),
  Maintainer = c(rep("Yuzhu Duan <yduan004@ucr.edu>", 12), "Brendan Gongol <bgong001@ucr.edu>"),
  RDataClass = c("character", "character", "character",
                 "character", "character",
                 "character", "data.frame", "data.frame",
                 "environment", "environment", "list", "data.frame",
                 "character"),
  DispatchClass = c("FilePath", "FilePath", "FilePath",
                    "FilePath", "FilePath",
                    "FilePath",
                    "RDS", "RDS", "RDS", "RDS", "RDS", "EpiMetadata",
                    "FilePath"),
  RDataPath = c("signatureSearchData/v0.1/cmap.h5",
                "signatureSearchData/v0.1/cmap_expr.h5",
                "signatureSearchData/v0.1/cmap_rank.h5",
                "signatureSearchData/v0.1/lincs.h5",
                "signatureSearchData/v0.1/lincs_expr.h5",
                "signatureSearchData/v0.1/dtlink_db_clue_sti.db", 
                "signatureSearchData/v0.1/goAnno.rds", 
                "signatureSearchData/v0.1/goAnno_drug.rds",
                "signatureSearchData/v0.1/GO_DATA.rds", 
                "signatureSearchData/v0.1/GO_DATA_drug.rds",
                "signatureSearchData/v0.1/taurefList.rds",
                "signatureSearchData/v0.1/ES_NULL.txt",
                "signatureSearchData/v0.2/lincs2020.h5"),
  Tags = c("CMAP", "CMAP_expr", "CMAP_rank",
           "LINCS", "LINCS_expr",
           "drug target", "GO", "GO",
           "GO","GO","lincs_tau","lincs_esnull",
           "LINCS2")
)
write.csv(meta, file="inst/extdata/metadata.csv", row.names=FALSE)
