% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesameData_annoProbes.R
\name{sesameData_annoProbes}
\alias{sesameData_annoProbes}
\title{Annotate Probes by Probe ID}
\usage{
sesameData_annoProbes(
  Probe_IDs,
  regs = NULL,
  collapse = TRUE,
  chooseOne = FALSE,
  column = NULL,
  sep = ",",
  return_ov_probes = FALSE,
  return_ov_features = FALSE,
  out_name = NULL,
  platform = NULL,
  genome = NULL,
  silent = FALSE
)
}
\arguments{
\item{Probe_IDs}{a character vector of probe IDs}

\item{regs}{a GenomicRanges::GRanges object against which
probes will be annotated, default to genes if not given}

\item{collapse}{whether to collapse multiple regs into one}

\item{chooseOne}{choose an arbitrary annotation if multiple exist
default to FALSE. which concatenates all with ","}

\item{column}{which column in regs to annotate, if not given
return all overlapping probes}

\item{sep}{the delimiter for collapsing}

\item{return_ov_probes}{if TRUE will return overlapping
probes in a GRanges object.}

\item{return_ov_features}{if TRUE will return overlapping
features in a GRanges object.}

\item{out_name}{column header of the annotation, use column if not given}

\item{platform}{EPIC, MM285 etc. will infer from Probe_IDs if not given}

\item{genome}{hg38, mm10, ... will infer if not given.
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., genome = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}

\item{silent}{suppress messages}
}
\value{
a GRanges with annotated column
If a probe has no overlap with regs, it will be included in the results
with NA. But if a probe is not included in the manifest (due to
mappability), it won't be included in the results.
}
\description{
Columns in the manifests will be added to the annotation.
Please note that if unfound, the annotation will be NA.
The probe will always be kept in the output.
}
\examples{
library(GenomicRanges)
sesameDataCache(c(
    "genomeInfo.mm10", "MM285.address",
    "genomeInfo.hg38", "Mammal40.address"))

regs = sesameData_getTxnGRanges("mm10")
Probe_IDs = names(sesameData_getManifestGRanges("MM285"))
anno = sesameData_annoProbes(Probe_IDs, promoters(regs), column="gene_name")

## get all genes associated with a probe set
genes = sesameData_getTxnGRanges("hg38", merge2gene = TRUE)
anno = sesameData_annoProbes(
    c("cg14620903","cg22464003"), genes, return_ov_features=TRUE)
}
