\name{SEQC-features}
\alias{ILM_aceview_gene_AGR}
\alias{ILM_aceview_gene_BGI}
\alias{ILM_aceview_gene_CNL}
\alias{ILM_aceview_gene_COH}
\alias{ILM_aceview_gene_MAY}
\alias{ILM_aceview_gene_NVS}
\alias{ILM_refseq_gene_AGR}
\alias{ILM_refseq_gene_BGI}
\alias{ILM_refseq_gene_CNL}
\alias{ILM_refseq_gene_COH}
\alias{ILM_refseq_gene_MAY}
\alias{ILM_refseq_gene_NVS}
\alias{LIF_aceview_gene_LIV}
\alias{LIF_aceview_gene_NWU}
\alias{LIF_aceview_gene_PSU}
\alias{LIF_aceview_gene_SQW}
\alias{LIF_refseq_gene_LIV}
\alias{LIF_refseq_gene_NWU}
\alias{LIF_refseq_gene_PSU}
\alias{LIF_refseq_gene_SQW}
\alias{ROC_aceview_gene_MGP}
\alias{ROC_aceview_gene_NYU}
\alias{ROC_aceview_gene_SQW}
\alias{ROC_refseq_gene_MGP}
\alias{ROC_refseq_gene_NYU}
\alias{ROC_refseq_gene_SQW}
\docType{package}
\title{
Read count tables from the SEQC project
}
\description{
This package contains 22 read counting tables (data frames). All these tables were generated from the RNA-Seq libraries from the SEQC project. Three platforms (Illumina, Roche 454 and SOLiD) were examined in the project at twelve different sites, and the libraries were mapped by using Subread. The reads (in the single-end libraries) or fragments (in the paired-end libraries) were then assigned to the annotated genes by using the featureCounts program on the single-end mode or the paired-end mode accordingly.

All the platforms and sequencing sites are listed in Table 1 in the vignette document of this package. This table also describes if each library is either single-end or paired-end. Please read the vignette document before using this package by using R command "vignette('seqc')".
}
\usage{
ILM_aceview_gene_AGR
ILM_aceview_gene_BGI
ILM_aceview_gene_CNL
ILM_aceview_gene_COH
ILM_aceview_gene_MAY
ILM_aceview_gene_NVS
LIF_aceview_gene_LIV
LIF_aceview_gene_NWU
LIF_aceview_gene_PSU
LIF_aceview_gene_SQW
ROC_aceview_gene_MGP
ROC_aceview_gene_NYU
ROC_aceview_gene_SQW
ILM_refseq_gene_AGR
ILM_refseq_gene_BGI
ILM_refseq_gene_CNL
ILM_refseq_gene_COH
ILM_refseq_gene_MAY
ILM_refseq_gene_NVS
LIF_refseq_gene_LIV
LIF_refseq_gene_NWU
LIF_refseq_gene_PSU
LIF_refseq_gene_SQW
ROC_refseq_gene_MGP
ROC_refseq_gene_NYU
ROC_refseq_gene_SQW
}
\details{
The 22 read counting tables are data frames providing the numbers of reads or fragments overlapping with the exon regions of each of the known human genes in the annotations. Two annotation sets were used in this package: the RefSeq annotations and the AceView annotations, both from the NCBI. The 22 data frames are named as to its origin; the naming scheme is (Platform)_(Annotation)_gene_(Site). For example, "LIF_refseq_gene_NMU" contains the read counts from all samples sequenced at NMU by using the SOLiD systems; the mapping results were then assigned to the RefSeq annotations.

Each of the data frames has many columns. The first three columns give the entrez ids, symbols and lengths of the genes, followed by a column of Boolean values indicating if each gene is actually an ERCC RNA Spike-In. After the fourth column are the columns for the read/fragment counts in the libraries; the column names are concatenated from three or four parts: (Sample)_(Replicate)_(Lane)_(FlowCell) for the tables generated by the Illumina platform or the SOLiD systems, or (Sample)_(Replicate)_(Region) for the tables generated by the Roche 454 platform. For example, column "ILM_aceview_gene_AGR$B_3_L02_FlowCellA" is a column of fragment counts on the third replicate of sample B, sequenced at AGR by using the Illumina HiSeq 2000 device (the second lane and flow cell A); the fragments were then assigned to the AceView annotations. 
}
\author{
Yang Liao, Wei Shi and Gordon K Smyth
}
\references{
Liao Y, Smyth GK and Shi W. The Subread aligner: fast, accurate and scalable read mapping by seed-and-vote. Nucleic Acids Research, 41(10):e108, 2013

Liao Y, Smyth GK and Shi W. featureCounts: an efficient general purpose program for assigning sequence reads to genomic features. Bioinformatics, 30(7):923-30, 2014

Su Z, Labaj PP, Li S, Thierry-Mieg J, Thierry-Mieg D, Shi W, Wang C, Schroth GP, Setterquist RA, Thompson JF, et al. (SEQC/MAQC-III Consortium). A comprehensive assessment of RNA-seq accuracy, reproducibility and information content by the Sequence Quality Control consortium. Nature Biotechnology, Published online 24 August 2014
}
\keyword{ SEQC }
\seealso{
Rsubread, voom
}
\examples{
	ls(2)
	colnames(ILM_aceview_gene_AGR)
	ILM_aceview_gene_AGR[1:10,1:10]
}
